/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.entity.projectile;

import com.binaris.wizardry.api.content.util.RayTracer;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBItems;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;

public abstract class MagicProjectileEntity
extends class_3857 {
    public static final double LAUNCH_Y_OFFSET = 0.3;
    public static final float FORWARD_OFFSET = 0.8f;
    public static final int SEEKING_TIME = 15;
    public float damageMultiplier = 1.0f;

    public MagicProjectileEntity(class_1299<? extends class_3857> entityType, class_1937 level) {
        super(entityType, level);
    }

    public MagicProjectileEntity(class_1299<? extends class_3857> entityType, class_1309 livingEntity, class_1937 level) {
        super(entityType, livingEntity, level);
    }

    public void method_5773() {
        super.method_5773();
        if (this.getLifeTime() >= 0 && this.field_6012 > this.getLifeTime()) {
            this.method_31472();
        }
        if (this.getSeekingStrength() <= 0.0f) {
            return;
        }
        class_239 hit = RayTracer.rayTrace(this.method_37908(), (class_1297)this, this.method_19538(), this.method_19538().method_1019(this.method_18798().method_1021(15.0)), this.getSeekingStrength(), false, class_1309.class, RayTracer.ignoreEntityFilter(null));
        if (hit instanceof class_3966) {
            class_3966 entityHit = (class_3966)hit;
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof class_1309) {
                class_1309 entity;
                class_1309 owner = (class_1309)class_12972;
                class_12972 = entityHit.method_17782();
                if (class_12972 instanceof class_1309 && AllyDesignation.isValidTarget((class_1297)owner, (class_1297)(entity = (class_1309)class_12972))) {
                    class_243 direction = new class_243(entity.field_6014, entity.field_6036 + (double)(entity.method_18377((class_4050)entity.method_18376()).field_18068 / 2.0f), entity.field_5969).method_1020(this.method_19538()).method_1029().method_1021(this.method_18798().method_1033());
                    this.method_18799(this.method_18798().method_1019(direction.method_1020(this.method_18798()).method_1021(0.13333333333333333)));
                }
            }
        }
    }

    public void aim(class_1309 caster, float speed) {
        class_243 lookVector = caster.method_5720();
        this.method_5814(caster.field_6014 + lookVector.field_1352 * (double)0.8f, caster.field_6036 + (double)caster.method_5751() - 0.3, caster.field_5969 + lookVector.field_1350 * (double)0.8f);
        this.method_24919((class_1297)caster, caster.method_36455(), caster.method_36454(), 0.0f, speed, 1.0f);
        this.method_7432((class_1297)caster);
    }

    public float getSeekingStrength() {
        class_1657 player;
        class_1297 class_12972 = this.method_24921();
        return class_12972 instanceof class_1657 && EBAccessoriesIntegration.isEquipped(player = (class_1657)class_12972, EBItems.RING_SEEKING.get()) ? 2 : 0;
    }

    public void aim(class_1309 caster, class_1297 target, float speed, float aimingError) {
        this.method_7432((class_1297)caster);
        this.field_6036 = caster.field_6036 + (double)caster.method_18377((class_4050)caster.method_18376()).field_18068 * (double)0.85f - 0.3;
        double dx = target.field_6014 - caster.field_6014;
        double dy = !this.method_5740() ? target.field_6036 + (double)(target.method_18377((class_4050)caster.method_18376()).field_18068 / 3.0f) - this.field_6036 : target.field_6036 + (double)(target.method_18377((class_4050)caster.method_18376()).field_18068 / 2.0f) - this.field_6036;
        double dz = target.field_5969 - caster.field_5969;
        double horizontalDistance = class_3532.method_15355((float)((float)(dx * dx + dz * dz)));
        if (horizontalDistance >= 1.0E-7) {
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, horizontalDistance) * 180.0 / Math.PI));
            double dxNormalised = dx / horizontalDistance;
            double dzNormalised = dz / horizontalDistance;
            this.method_5641(caster.field_6014 + dxNormalised, this.field_6036, caster.field_5969 + dzNormalised, yaw, pitch);
            float bulletDropCompensation = !this.method_5740() ? (float)horizontalDistance * 0.2f : 0.0f;
            this.method_7485(dx, dy + (double)bulletDropCompensation, dz, speed, aimingError);
        }
    }

    public void method_5651(@NotNull class_2487 tag) {
        super.method_5651(tag);
        this.damageMultiplier = tag.method_10583("damageMultiplier");
    }

    public boolean method_5662(class_2487 tag) {
        tag.method_10548("damageMultiplier", this.damageMultiplier);
        return super.method_5662(tag);
    }

    public int getLifeTime() {
        return -1;
    }
}

