/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell;

import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.NoneSpell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.core.ClientSpellSoundManager;
import com.binaris.wizardry.core.platform.Services;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public abstract class Spell {
    protected float volume = 1.0f;
    protected float pitch = 1.0f;
    protected float pitchVariation = 0.0f;
    private String descriptionId;
    private class_2960 location;
    private class_2960 icon;
    private SpellProperties properties = this.properties();
    private boolean ended;

    public abstract boolean cast(PlayerCastContext var1);

    public boolean cast(EntityCastContext ctx) {
        return false;
    }

    public boolean cast(LocationCastContext ctx) {
        return false;
    }

    public void endCast(CastContext cxt) {
        this.ended = true;
    }

    public void onCharge(CastContext ctx) {
    }

    public final boolean hasEnded() {
        return this.ended;
    }

    public boolean isInstantCast() {
        return true;
    }

    public boolean canCastByEntity() {
        return false;
    }

    public boolean canCastByLocation() {
        return false;
    }

    public final Boolean isEmpty() {
        return this instanceof NoneSpell;
    }

    public boolean requiresPacket() {
        return true;
    }

    public class_2561 getDescriptionFormatted() {
        return class_2561.method_43471((String)this.getOrCreateDescriptionId()).method_27692(this.getElement().getColor());
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = class_156.method_646((String)"spell", (class_2960)Services.REGISTRY_UTIL.getSpell(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    protected class_2960 getOrCreateLocation() {
        if (this.location == null) {
            this.location = Services.REGISTRY_UTIL.getSpell(this);
        }
        return this.location;
    }

    public class_2960 getLocation() {
        return this.getOrCreateLocation();
    }

    public class_2561 getDesc() {
        return class_2561.method_43471((String)(this.getOrCreateDescriptionId() + ".desc"));
    }

    public class_2960 getIcon() {
        if (this.icon == null) {
            class_2960 location = this.getOrCreateLocation();
            this.icon = new class_2960(location.method_12836(), "textures/spells/" + location.method_12832() + ".png");
        }
        return this.icon;
    }

    public final boolean is(class_2960 location) {
        return location.equals((Object)this.getLocation());
    }

    public final boolean is(String location) {
        return location.equals(this.getLocation().toString());
    }

    public final SpellProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SpellProperties properties) {
        this.properties = properties;
    }

    @NotNull
    protected abstract SpellProperties properties();

    public final Spell assignProperties(SpellProperties properties) {
        this.properties = properties;
        return this;
    }

    public final <T> T property(SpellProperty<T> property) {
        return this.properties.get(property);
    }

    public final boolean is(Spell spell) {
        return spell.getDescriptionId().equals(this.descriptionId);
    }

    public int getCharge() {
        return this.properties.getChargeup();
    }

    public SpellType getType() {
        return this.properties.getType();
    }

    public SpellAction getAction() {
        return this.properties.getAction();
    }

    public Element getElement() {
        return this.properties.getElement();
    }

    public SpellTier getTier() {
        return this.properties.getTier();
    }

    public int getCost() {
        return this.properties.getCost();
    }

    public int getCooldown() {
        return this.properties.getCooldown();
    }

    public boolean isEnabled(SpellContext context) {
        return this.properties.isEnabledInContext(context);
    }

    public String toString() {
        return this.getLocation().toString();
    }

    public Spell soundValues(float volume, float pitch, float pitchVariation) {
        this.volume = volume;
        this.pitch = pitch;
        this.pitchVariation = pitchVariation;
        return this;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getPitchVariation() {
        return this.pitchVariation;
    }

    protected void playSound(class_1937 world, class_1309 entity, int castTicks, int duration) {
        if (!entity.method_5701()) {
            this.playSound(world, entity.method_23317(), entity.method_23318(), entity.method_23321(), castTicks, duration);
        }
    }

    protected void playSound(class_1937 world, class_243 pos, int castTicks, int duration) {
        this.playSound(world, pos.field_1352, pos.field_1351, pos.field_1350, castTicks, duration);
    }

    protected void playSound(class_1937 world, double x, double y, double z, int ticksInUse, int duration) {
        class_3414 sound = class_3414.method_47908((class_2960)new class_2960(this.getLocation().method_12836(), "spell." + this.getLocation().method_12832()));
        world.method_43128(null, x, y, z, sound, class_3419.field_15248, this.getVolume(), this.getPitch() + this.getPitchVariation() * (world.field_9229.method_43057() - 0.5f));
    }

    protected final void playSoundLoop(class_1937 world, class_1309 entity, int ticksInUse) {
        if (ticksInUse == 0 && world.field_9236) {
            ClientSpellSoundManager.playSpellSoundLoop(entity, this, this.getLoopSounds(), this.volume, this.pitch + this.pitchVariation * (world.field_9229.method_43057() - 0.5f));
        }
    }

    protected final void playSoundLoop(class_1937 world, double x, double y, double z, int ticksInUse, int duration) {
        if (ticksInUse == 0 && world.field_9236) {
            ClientSpellSoundManager.playSpellSoundLoop(world, x, y, z, this, this.getLoopSounds(), this.volume, this.pitch + this.pitchVariation * (world.field_9229.method_43057() - 0.5f), duration);
        }
    }

    protected class_3414[] getLoopSounds() {
        List<String> names = List.of("start", "loop", "end");
        return (class_3414[])names.stream().map(name -> class_3414.method_47908((class_2960)new class_2960(this.getLocation().method_12836(), "spell." + this.getLocation().method_12832() + "." + name))).toArray(class_3414[]::new);
    }
}

