/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_572;
import org.jetbrains.annotations.Nullable;

public class SpellAction {
    public static final SpellAction POINT;
    public static SpellAction POINT_UP;
    public static SpellAction POINT_DOWN;
    public static SpellAction SUMMON;
    public static SpellAction THRUST;
    public static SpellAction IMBUE;
    public static SpellAction GRAPPLE;
    public static SpellAction NONE;
    static List<SpellAction> spellActions;
    public class_2960 location;

    public SpellAction(class_2960 location) {
        this.location = location;
        spellActions.add(this);
    }

    public static void register() {
    }

    @Nullable
    public static SpellAction get(class_2960 location) {
        for (SpellAction action : spellActions) {
            if (!action.location.equals((Object)location)) continue;
            return action;
        }
        return null;
    }

    public void renderArms(class_1309 entity, class_572<?> model, class_1268 hand) {
    }

    public boolean shouldRender(class_1309 entity, Spell spell, class_1799 stack, class_1268 hand) {
        return spell != null && spell.getAction() != NONE && entity.method_6115();
    }

    static {
        spellActions = new ArrayList<SpellAction>();
        POINT = new SpellAction(WizardryMainMod.location("point")){

            @Override
            public void renderArms(class_1309 entity, class_572<?> model, class_1268 hand) {
                float pitch = (float)Math.toRadians(entity.method_36455());
                float yaw = (float)Math.toRadians(entity.field_6241 - entity.field_6283);
                float x = -1.5707964f + pitch + 0.2f;
                float y = (hand == class_1268.field_5808 ? -0.25f : 0.25f) + yaw;
                if (hand == class_1268.field_5808) {
                    model.field_3401.method_33425(x, y, 0.0f);
                } else {
                    model.field_27433.method_33425(x, y, 0.0f);
                }
            }
        };
        POINT_UP = new SpellAction(WizardryMainMod.location("point_up")){

            @Override
            public void renderArms(class_1309 entity, class_572<?> model, class_1268 hand) {
                if (hand == class_1268.field_5808) {
                    model.field_3401.method_33425(-2.2f, 0.2f, 0.0f);
                } else {
                    model.field_27433.method_33425(-2.2f, -0.2f, 0.0f);
                }
            }
        };
        POINT_DOWN = new SpellAction(WizardryMainMod.location("point_down")){

            @Override
            public void renderArms(class_1309 entity, class_572<?> model, class_1268 hand) {
                float tick = Math.abs(entity.method_6014());
                float y = Math.min(0.4f + tick * 0.05f, 0.7f);
                if (hand == class_1268.field_5808) {
                    model.field_3401.method_33425(-0.2f, y, 0.0f);
                } else {
                    model.field_27433.method_33425(-0.2f, -y, 0.0f);
                }
            }
        };
        SUMMON = new SpellAction(WizardryMainMod.location("summon")){

            @Override
            public void renderArms(class_1309 entity, class_572<?> model, class_1268 hand) {
                float tick = Math.abs(entity.method_6014());
                float x = -Math.min(0.4f + tick * 0.2f, 2.0f);
                model.field_3401.method_33425(x, 1.2f, 0.0f);
                model.field_27433.method_33425(x, -1.2f, 0.0f);
            }
        };
        IMBUE = new SpellAction(WizardryMainMod.location("imbue")){

            @Override
            public void renderArms(class_1309 entity, class_572<?> model, class_1268 hand) {
                class_1268 opposite;
                float tick = Math.abs(entity.method_6014());
                float z = Math.max(1.5f - tick * 0.1f, 0.8f);
                if (hand == class_1268.field_5808) {
                    model.field_3401.method_33425(-1.2f, -0.2f, z);
                } else {
                    model.field_27433.method_33425(-1.2f, 0.2f, -z);
                }
                class_1268 class_12682 = opposite = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
                if (!entity.method_5998(opposite).method_7960()) {
                    if (hand == class_1268.field_5810) {
                        model.field_3401.method_33425(-0.8f, 0.3f, 0.0f);
                    } else {
                        model.field_27433.method_33425(-0.8f, 0.3f, 0.0f);
                    }
                }
            }
        };
        THRUST = new SpellAction(WizardryMainMod.location("thrust")){

            @Override
            public void renderArms(class_1309 entity, class_572<?> model, class_1268 hand) {
                class_1268 opposite;
                if (hand == class_1268.field_5808) {
                    model.field_3401.method_33425(-1.2f, -0.6f, 0.0f);
                } else {
                    model.field_27433.method_33425(-1.2f, 0.6f, 0.0f);
                }
                class_1268 class_12682 = opposite = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
                if (entity.method_5998(opposite).method_7960()) {
                    if (opposite == class_1268.field_5808) {
                        model.field_3401.method_33425(-1.2f, -0.6f, 0.0f);
                    } else {
                        model.field_27433.method_33425(-1.2f, 0.6f, 0.0f);
                    }
                }
            }
        };
        GRAPPLE = new SpellAction(WizardryMainMod.location("grapple"));
        NONE = new SpellAction(WizardryMainMod.location("none"));
    }
}

