/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell;

import com.binaris.wizardry.core.platform.Services;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SpellTier {
    public final int maxCharge;
    public final int level;
    public final int upgradeLimit;
    public final int weight;
    private final int progression;
    private final class_124 color;
    private String descriptionId;
    private class_2960 location;

    public SpellTier(int maxCharge, int upgradeLimit, int weight, int level, class_124 color, int progression) {
        this.maxCharge = maxCharge;
        this.level = level;
        this.upgradeLimit = upgradeLimit;
        this.weight = weight;
        this.color = color;
        this.progression = progression;
    }

    public static SpellTier getWeightedRandomTier(class_5819 random, SpellTier ... tiers) {
        int totalWeight = 0;
        for (SpellTier tier : tiers) {
            totalWeight += tier.weight;
        }
        int randomiser = random.method_43048(totalWeight);
        int cumulativeWeight = 0;
        for (SpellTier tier : tiers) {
            if (randomiser >= (cumulativeWeight += tier.weight)) continue;
            return tier;
        }
        return tiers[tiers.length - 1];
    }

    public SpellTier next() {
        List<SpellTier> tiers = Services.REGISTRY_UTIL.getTiers().stream().toList();
        int thisTierID = tiers.indexOf(this);
        return thisTierID < Services.REGISTRY_UTIL.getTiers().size() - 1 ? tiers.get(thisTierID + 1) : tiers.get(tiers.size() - 1);
    }

    public SpellTier previous() {
        List<SpellTier> tiers = Services.REGISTRY_UTIL.getTiers().stream().toList();
        int thisTierID = tiers.indexOf(this);
        return thisTierID > 0 ? tiers.get(thisTierID - 1) : tiers.get(0);
    }

    public class_2561 getDescriptionFormatted() {
        return class_2561.method_43471((String)this.getOrCreateDescriptionId()).method_27692(this.color);
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = class_156.method_646((String)"tier", (class_2960)Services.REGISTRY_UTIL.getTier(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    @Nullable
    public class_2960 getOrCreateLocation() {
        if (this.location == null) {
            this.location = Services.REGISTRY_UTIL.getTier(this);
        }
        return this.location;
    }

    public class_2960 getLocation() {
        return this.getOrCreateLocation();
    }

    public void setLocation(class_2960 location) {
        if (this.location != null) {
            throw new IllegalStateException("Location already set for tier");
        }
        this.location = location;
    }

    public final boolean is(class_2960 location) {
        return location.equals((Object)this.getLocation());
    }

    public String toString() {
        return this.getLocation().toString();
    }

    public class_124 getColor() {
        return this.color;
    }

    public int getProgression() {
        return this.progression;
    }
}

