/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell.internal;

import com.binaris.wizardry.setup.registries.WandUpgrades;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2487;

public final class SpellModifiers {
    public static final String POTENCY = "potency";
    public static final String COST = "cost";
    public static final String CHARGEUP = "chargeup";
    public static final String PROGRESSION = "progression";
    private final Map<String, Float> multiplierMap = new HashMap<String, Float>();
    private final Map<String, Float> syncedMultiplierMap = new HashMap<String, Float>();

    public static SpellModifiers fromTag(class_2487 tag) {
        SpellModifiers modifiers = new SpellModifiers();
        tag.method_10541().forEach(key -> modifiers.set((String)key, tag.method_10583(key), true));
        return modifiers;
    }

    public class_2487 toTag() {
        class_2487 nbt = new class_2487();
        this.multiplierMap.forEach((arg_0, arg_1) -> ((class_2487)nbt).method_10548(arg_0, arg_1));
        return nbt;
    }

    public SpellModifiers combine(SpellModifiers modifiers) {
        for (String key : Sets.union(this.multiplierMap.keySet(), modifiers.multiplierMap.keySet())) {
            float newValue = this.get(key) * modifiers.get(key);
            boolean sync = this.syncedMultiplierMap.containsKey(key) || modifiers.syncedMultiplierMap.containsKey(key);
            this.set(key, newValue, sync);
        }
        return this;
    }

    public SpellModifiers set(class_1792 upgrade, float multiplier, boolean needsSyncing) {
        this.set(WandUpgrades.getIdentifier(upgrade), multiplier, needsSyncing);
        return this;
    }

    public SpellModifiers set(String key, float multiplier, boolean needsSyncing) {
        this.multiplierMap.put(key, Float.valueOf(multiplier));
        if (needsSyncing) {
            this.syncedMultiplierMap.put(key, Float.valueOf(multiplier));
        }
        return this;
    }

    public float get(class_1792 upgrade) {
        return this.get(WandUpgrades.getIdentifier(upgrade));
    }

    public float get(String key) {
        Float value = this.multiplierMap.get(key);
        return value == null ? 1.0f : value.floatValue();
    }

    public Map<String, Float> getMultipliers() {
        return this.multiplierMap;
    }

    public Map<String, Float> getSyncedMultipliers() {
        return this.syncedMultiplierMap;
    }

    public void reset() {
        this.multiplierMap.clear();
        this.syncedMultiplierMap.clear();
    }
}

