/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell.properties;

import com.binaris.wizardry.api.content.spell.properties.IPropertyType;
import com.binaris.wizardry.api.content.spell.properties.PropertyType;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public final class PropertyTypes {
    private static final Map<String, IPropertyType<?>> PROPERTY_TYPES = new HashMap();
    public static final PropertyType<Byte> BYTE = PropertyTypes.addType("byte_", (t, s) -> PropertyTypes.deserializeNbt(t, s, a -> t.method_10571(s)), (j, s) -> PropertyTypes.deserializeJson(j, s, JsonElement::getAsByte), (j, p) -> PropertyTypes.serializeJson(j, p, (obj, val) -> obj.addProperty(p.identifier, (Number)val)), (t, p) -> PropertyTypes.serializeNbt(t, p, (tag, val) -> tag.method_10567(p.identifier, val.byteValue())));
    public static final PropertyType<Short> SHORT = PropertyTypes.addType("short_", (t, s) -> PropertyTypes.deserializeNbt(t, s, a -> t.method_10568(s)), (j, s) -> PropertyTypes.deserializeJson(j, s, JsonElement::getAsShort), (j, p) -> PropertyTypes.serializeJson(j, p, (obj, val) -> obj.addProperty(p.identifier, (Number)val)), (t, p) -> PropertyTypes.serializeNbt(t, p, (tag, val) -> tag.method_10575(p.identifier, val.shortValue())));
    public static final PropertyType<Integer> INT = PropertyTypes.addType("int_", (t, s) -> PropertyTypes.deserializeNbt(t, s, a -> t.method_10550(s)), (j, s) -> PropertyTypes.deserializeJson(j, s, JsonElement::getAsInt), (j, p) -> PropertyTypes.serializeJson(j, p, (obj, val) -> obj.addProperty(p.identifier, (Number)val)), (t, p) -> PropertyTypes.serializeNbt(t, p, (tag, val) -> tag.method_10569(p.identifier, val.intValue())));
    public static final PropertyType<Long> LONG = PropertyTypes.addType("long_", (t, s) -> PropertyTypes.deserializeNbt(t, s, a -> t.method_10537(s)), (j, s) -> PropertyTypes.deserializeJson(j, s, JsonElement::getAsLong), (j, p) -> PropertyTypes.serializeJson(j, p, (obj, val) -> obj.addProperty(p.identifier, (Number)val)), (t, p) -> PropertyTypes.serializeNbt(t, p, (tag, val) -> tag.method_10544(p.identifier, val.longValue())));
    public static final PropertyType<Float> FLOAT = PropertyTypes.addType("float_", (t, s) -> PropertyTypes.deserializeNbt(t, s, a -> Float.valueOf(t.method_10583(s))), (j, s) -> PropertyTypes.deserializeJson(j, s, JsonElement::getAsFloat), (j, p) -> PropertyTypes.serializeJson(j, p, (obj, val) -> obj.addProperty(p.identifier, (Number)val)), (t, p) -> PropertyTypes.serializeNbt(t, p, (tag, val) -> tag.method_10548(p.identifier, val.floatValue())));
    public static final PropertyType<Double> DOUBLE = PropertyTypes.addType("double_", (t, s) -> PropertyTypes.deserializeNbt(t, s, a -> t.method_10574(s)), (j, s) -> PropertyTypes.deserializeJson(j, s, JsonElement::getAsDouble), (j, p) -> PropertyTypes.serializeJson(j, p, (obj, val) -> obj.addProperty(p.identifier, (Number)val)), (t, p) -> PropertyTypes.serializeNbt(t, p, (tag, val) -> tag.method_10549(p.identifier, val.doubleValue())));
    public static final PropertyType<Boolean> BOOLEAN = PropertyTypes.addType("boolean_", (t, s) -> PropertyTypes.deserializeNbt(t, s, a -> t.method_10577(s)), (j, s) -> PropertyTypes.deserializeJson(j, s, JsonElement::getAsBoolean), (j, p) -> PropertyTypes.serializeJson(j, p, (obj, val) -> obj.addProperty(p.identifier, val)), (t, p) -> PropertyTypes.serializeNbt(t, p, (tag, val) -> tag.method_10556(p.identifier, val.booleanValue())));
    public static final PropertyType<String> STRING = PropertyTypes.addType("string_", (t, s) -> PropertyTypes.deserializeNbt(t, s, a -> t.method_10558(s)), (j, s) -> PropertyTypes.deserializeJson(j, s, JsonElement::getAsString), (j, p) -> PropertyTypes.serializeJson(j, p, (obj, val) -> obj.addProperty(p.identifier, val)), (t, p) -> PropertyTypes.serializeNbt(t, p, (tag, val) -> tag.method_10582(p.identifier, val)));
    public static final PropertyType<Map<String, Boolean>> CONTEXT_MAP = PropertyTypes.addType("context_map_", PropertyTypes::deserializeContextMapNbt, PropertyTypes::deserializeContextMapJson, PropertyTypes::serializeContextMapJson, PropertyTypes::serializeContextMapNbt);

    private PropertyTypes() {
    }

    public static <T> IPropertyType<T> addType(String id, IPropertyType<T> propertyType) {
        PROPERTY_TYPES.put(id, propertyType);
        return propertyType;
    }

    @Nullable
    public static IPropertyType<?> getType(String id) {
        return PROPERTY_TYPES.getOrDefault(id, null);
    }

    public static boolean hasType(String id) {
        return PROPERTY_TYPES.containsKey(id);
    }

    public static Map<String, IPropertyType<?>> getAllTypes() {
        return PROPERTY_TYPES;
    }

    private static <T> PropertyType<T> addType(String name, BiFunction<class_2487, String, SpellProperty<T>> tagDeserializer, BiFunction<JsonElement, String, SpellProperty<T>> jsonDeserializer, BiConsumer<JsonObject, SpellProperty<T>> jsonSerializer, BiConsumer<class_2487, SpellProperty<T>> tagSerializer) {
        return (PropertyType)PropertyTypes.addType(name, new PropertyType<T>(jsonDeserializer, tagDeserializer, jsonSerializer, tagSerializer));
    }

    private static <T> SpellProperty<T> deserializeNbt(class_2487 tag, String location, Function<String, T> getter) {
        SpellProperty<?> base = SpellProperty.fromID(location);
        if (base == null) {
            throw new IllegalArgumentException("No property found with identifier: " + location);
        }
        SpellProperty<?> property = base.copyOf();
        property.value = getter.apply(location);
        return property;
    }

    private static <T> SpellProperty<T> deserializeJson(JsonElement json, String location, Function<JsonElement, T> getter) {
        SpellProperty<?> base = SpellProperty.fromID(location);
        if (base == null) {
            throw new IllegalArgumentException("No property found with identifier: " + location);
        }
        SpellProperty<?> property = base.copyOf();
        try {
            property.value = getter.apply(json);
        }
        catch (IllegalStateException | UnsupportedOperationException e) {
            throw new IllegalArgumentException("Invalid JSON type for property '" + location + "'. Expected a primitive value but got: " + String.valueOf(json), e);
        }
        return property;
    }

    private static SpellProperty<Map<String, Boolean>> deserializeContextMapNbt(class_2487 tag, String location) {
        SpellProperty<?> base = SpellProperty.fromID(location);
        if (base == null) {
            throw new IllegalArgumentException("No property found with identifier: " + location);
        }
        SpellProperty<Map<String, Boolean>> property = base.copyOf();
        HashMap<String, Boolean> contextMap = new HashMap<String, Boolean>();
        class_2487 contextTag = tag.method_10562(location);
        for (String key : contextTag.method_10541()) {
            contextMap.put(key, contextTag.method_10577(key));
        }
        property.value = contextMap;
        return property;
    }

    private static SpellProperty<Map<String, Boolean>> deserializeContextMapJson(JsonElement json, String location) {
        SpellProperty<?> base = SpellProperty.fromID(location);
        if (base == null) {
            throw new IllegalArgumentException("No property found with identifier: " + location);
        }
        SpellProperty<Map<String, Boolean>> property = base.copyOf();
        HashMap contextMap = new HashMap();
        if (json.isJsonObject()) {
            JsonObject contextObj = json.getAsJsonObject();
            contextObj.entrySet().forEach(entry -> contextMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean()));
        }
        property.value = contextMap;
        return property;
    }

    private static void serializeContextMapJson(JsonObject json, SpellProperty<Map<String, Boolean>> property) {
        JsonObject contextObj = new JsonObject();
        ((Map)property.value).forEach((arg_0, arg_1) -> ((JsonObject)contextObj).addProperty(arg_0, arg_1));
        json.add(property.identifier, (JsonElement)contextObj);
    }

    private static void serializeContextMapNbt(class_2487 tag, SpellProperty<Map<String, Boolean>> property) {
        class_2487 contextTag = new class_2487();
        ((Map)property.value).forEach((arg_0, arg_1) -> ((class_2487)contextTag).method_10556(arg_0, arg_1));
        tag.method_10566(property.identifier, (class_2520)contextTag);
    }

    private static <T> void serializeJson(JsonObject json, SpellProperty<T> property, BiConsumer<JsonObject, T> setter) {
        setter.accept(json, (JsonObject)property.value);
    }

    private static <T> void serializeNbt(class_2487 tag, SpellProperty<T> property, BiConsumer<class_2487, T> setter) {
        setter.accept(tag, (class_2487)property.value);
    }
}

