/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell.properties;

import com.binaris.wizardry.api.content.spell.properties.IPropertyType;
import com.binaris.wizardry.api.content.spell.properties.PropertyTypes;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SpellProperty<T> {
    private static final Set<SpellProperty<?>> PROPERTIES = new HashSet();
    protected String identifier = null;
    protected T value = null;
    protected T defaultValue = null;
    protected IPropertyType<T> type = null;

    private SpellProperty() {
    }

    public static SpellProperty<Byte> byteProperty(String id) {
        return SpellProperty.byteProperty(id, (byte)0);
    }

    public static SpellProperty<Short> shortProperty(String id) {
        return SpellProperty.shortProperty(id, (short)0);
    }

    public static SpellProperty<Integer> intProperty(String id) {
        return SpellProperty.intProperty(id, 0);
    }

    public static SpellProperty<Long> longProperty(String id) {
        return SpellProperty.longProperty(id, 0L);
    }

    public static SpellProperty<Float> floatProperty(String id) {
        return SpellProperty.floatProperty(id, 0.0f);
    }

    public static SpellProperty<Double> doubleProperty(String id) {
        return SpellProperty.doubleProperty(id, 0.0);
    }

    public static SpellProperty<Boolean> booleanProperty(String id) {
        return SpellProperty.booleanProperty(id, false);
    }

    public static SpellProperty<String> stringProperty(String id) {
        return SpellProperty.stringProperty(id, "");
    }

    public static SpellProperty<Byte> byteProperty(String id, byte value) {
        return SpellProperty.createProperty(id, value, PropertyTypes.BYTE);
    }

    public static SpellProperty<Short> shortProperty(String id, short value) {
        return SpellProperty.createProperty(id, value, PropertyTypes.SHORT);
    }

    public static SpellProperty<Integer> intProperty(String id, int value) {
        return SpellProperty.createProperty(id, value, PropertyTypes.INT);
    }

    public static SpellProperty<Long> longProperty(String id, long value) {
        return SpellProperty.createProperty(id, value, PropertyTypes.LONG);
    }

    public static SpellProperty<Float> floatProperty(String id, float value) {
        return SpellProperty.createProperty(id, Float.valueOf(value), PropertyTypes.FLOAT);
    }

    public static SpellProperty<Double> doubleProperty(String id, double value) {
        return SpellProperty.createProperty(id, value, PropertyTypes.DOUBLE);
    }

    public static SpellProperty<Boolean> booleanProperty(String id, boolean value) {
        return SpellProperty.createProperty(id, value, PropertyTypes.BOOLEAN);
    }

    public static SpellProperty<String> stringProperty(String id, String value) {
        return SpellProperty.createProperty(id, value, PropertyTypes.STRING);
    }

    public static SpellProperty<Map<String, Boolean>> contextMapProperty(String id, Map<String, Boolean> value) {
        return SpellProperty.createProperty(id, value, PropertyTypes.CONTEXT_MAP);
    }

    protected static <T> SpellProperty<T> createProperty(String identifier, T defaultValue, IPropertyType<T> type) {
        SpellProperty<T> property = new SpellProperty<T>();
        property.identifier = identifier;
        property.type = type;
        property.defaultValue = defaultValue;
        property.value = defaultValue;
        PROPERTIES.add(property);
        return property;
    }

    @Nullable
    public static SpellProperty<?> fromID(String identifier) {
        return PROPERTIES.stream().filter(p -> p.identifier.equals(identifier)).findFirst().orElse(null);
    }

    public T get() {
        return this.value;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void set(T value) {
        this.value = value;
    }

    SpellProperty<T> defaultValue(T value) {
        this.defaultValue = value;
        this.value = value;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpellProperty) {
            SpellProperty property = (SpellProperty)obj;
            return property.identifier.equals(this.identifier) && property.type.equals(this.type);
        }
        return false;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public SpellProperty<T> copyOf() {
        SpellProperty<T> cloned = new SpellProperty<T>();
        cloned.identifier = this.identifier;
        cloned.type = this.type;
        cloned.defaultValue = this.defaultValue;
        cloned.value = this.value;
        return cloned;
    }
}

