/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.core.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public final class BlockUtil {
    public static boolean canBlockBeReplaced(class_1937 world, class_2338 pos) {
        return BlockUtil.canBlockBeReplaced(world, pos, false);
    }

    public static Integer getNearestFloor(class_1937 world, class_2338 pos, int range) {
        return BlockUtil.getNearestSurface(world, pos, class_2350.field_11036, range, true, SurfaceCriteria.COLLIDABLE);
    }

    public static boolean canBlockBeReplaced(class_1937 world, class_2338 pos, boolean excludeLiquids) {
        return !(!world.method_22347(new class_2338((class_2382)pos)) && !world.method_8320(pos).method_45474() || excludeLiquids && world.method_8320(pos).method_51176());
    }

    public static boolean canBreak(class_1657 player, class_1937 level, class_2338 pos, boolean powerful) {
        if (level.field_9236) {
            EBLogger.error("BlockUtils#canBreak called from the client side! Blocks should be modified server-side only", new Object[0]);
            return true;
        }
        if (Services.PLATFORM.firePlayerBlockBreakEvent(level, pos, player)) {
            return false;
        }
        if (player.method_7337()) {
            return true;
        }
        if (!player.method_7294()) {
            return false;
        }
        if (level.method_31606(pos)) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        if (state.method_26214((class_1922)level, pos) < 0.0f) {
            return false;
        }
        if (player.method_7325()) {
            return false;
        }
        if (state.method_26214((class_1922)level, pos) > 3.0f && !powerful) {
            return false;
        }
        return level.method_8505(player, pos);
    }

    public static boolean canBreak(class_1308 mob, class_1937 level, class_2338 pos) {
        if (level.field_9236) {
            EBLogger.error("BlockUtils#canBreak called from the client side! Blocks should be modified server-side only", new Object[0]);
            return true;
        }
        if (Services.PLATFORM.fireMobBlockBreakEvent(level, pos, mob)) {
            return false;
        }
        if (level.method_31606(pos)) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        if (state.method_26214((class_1922)level, pos) < 0.0f) {
            return false;
        }
        return !(state.method_26214((class_1922)level, pos) > 3.0f);
    }

    public static class_2350[] getHorizontals() {
        return (class_2350[])Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166().method_10179()).sorted(Comparator.comparingInt(class_2350::method_10161)).toArray(class_2350[]::new);
    }

    public static boolean canPlaceBlock(class_1309 placer, class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            EBLogger.error("BlockUtils#canPlaceBlock called from the client side! Blocks should be modified server-side only", new Object[0]);
            return true;
        }
        if (!EntityUtil.canDamageBlocks(placer, world)) {
            return false;
        }
        if (world.method_31606(pos)) {
            return false;
        }
        return !(placer instanceof class_1657) || world.method_8505((class_1657)placer, pos);
    }

    @Nullable
    public static class_2338 findNearbyFloorSpace(class_1297 entity, int horizontalRange, int verticalRange) {
        class_1937 world = entity.method_37908();
        class_2338 origin = entity.method_24515();
        return BlockUtil.findNearbyFloorSpace(world, origin, horizontalRange, verticalRange, true, entity);
    }

    @Nullable
    public static class_2338 findNearbyFloorSpace(class_1937 world, class_2338 origin, int horizontalRange, int verticalRange, boolean lineOfSight, class_1297 entity) {
        ArrayList<class_2338> possibleLocations = new ArrayList<class_2338>();
        class_243 centre = GeometryUtil.getCentre(origin);
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                class_3965 rayTrace;
                Integer y = BlockUtil.getNearestFloor(world, origin.method_10069(x, 0, z), verticalRange);
                if (y == null) continue;
                class_2338 location = new class_2338(origin.method_10263() + x, y.intValue(), origin.method_10260() + z);
                if (lineOfSight && (rayTrace = world.method_17742(new class_3959(centre, GeometryUtil.getCentre(location), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, entity))).method_17783() == class_239.class_240.field_1332) continue;
                possibleLocations.add(location);
            }
        }
        if (possibleLocations.isEmpty()) {
            return null;
        }
        return (class_2338)possibleLocations.get(world.field_9229.method_43048(possibleLocations.size()));
    }

    @Nullable
    public static class_2338 findNearbyFloorSpace(class_1937 world, class_2338 origin, int horizontalRange, int verticalRange, boolean lineOfSight) {
        ArrayList<class_2338> possibleLocations = new ArrayList<class_2338>();
        class_243 centre = GeometryUtil.getCentre(origin);
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                class_3965 rayTrace;
                Integer y = BlockUtil.getNearestFloor(world, origin.method_10069(x, 0, z), verticalRange);
                if (y == null) continue;
                class_2338 location = new class_2338(origin.method_10263() + x, y.intValue(), origin.method_10260() + z);
                if (lineOfSight && (rayTrace = world.method_17742(new class_3959(centre, GeometryUtil.getCentre(location), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, null))).method_17783() == class_239.class_240.field_1332) continue;
                possibleLocations.add(location);
            }
        }
        if (possibleLocations.isEmpty()) {
            return null;
        }
        return (class_2338)possibleLocations.get(world.field_9229.method_43048(possibleLocations.size()));
    }

    public static boolean isBlockUnbreakable(class_1937 world, class_2338 pos) {
        return !world.method_22347(new class_2338((class_2382)pos)) && world.method_8320(pos).method_51367();
    }

    public static List<class_2338> getBlockSphere(class_2338 centre, double radius) {
        ArrayList<class_2338> sphere = new ArrayList<class_2338>((int)Math.pow(radius, 3.0));
        int i = -((int)radius);
        while ((double)i <= radius) {
            float r1 = class_3532.method_15355((float)((float)(radius * radius - (double)(i * i))));
            int j = -((int)r1);
            while ((float)j <= r1) {
                float r2 = class_3532.method_15355((float)((float)(radius * radius - (double)(i * i) - (double)(j * j))));
                int k = -((int)r2);
                while ((float)k <= r2) {
                    sphere.add(centre.method_10069(i, j, k));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return sphere;
    }

    @Nullable
    public static Integer getNearestSurface(class_1937 world, class_2338 pos, class_2350 direction, int range, boolean doubleSided, SurfaceCriteria criteria) {
        int i;
        Integer surface = null;
        int currentBest = Integer.MAX_VALUE;
        int n = i = doubleSided ? -range : 0;
        while (i <= range && i < currentBest) {
            class_2338 testPos = pos.method_10079(direction, i);
            if (criteria.test(world, testPos, direction)) {
                surface = (int)GeometryUtil.component(GeometryUtil.getFaceCentre(testPos, direction), direction.method_10166());
                currentBest = Math.abs(i);
            }
            ++i;
        }
        return surface;
    }

    public static boolean freeze(class_1937 world, class_2338 pos, boolean freezeLava) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (state.method_26204() == class_2246.field_10382 && (Integer)state.method_11654((class_2769)class_2404.field_11278) == 0) {
            world.method_8501(pos, class_2246.field_10295.method_9564());
        } else if (freezeLava && state.method_26204() == class_2246.field_10164 && (Integer)state.method_11654((class_2769)class_2404.field_11278) == 0) {
            world.method_8501(pos, class_2246.field_10540.method_9564());
        } else if (freezeLava && block == class_2246.field_10164) {
            world.method_8501(pos, class_2246.field_10445.method_9564());
        } else if (BlockUtil.canBlockBeReplaced(world, pos.method_10084()) && class_2246.field_10477.method_9564().method_26184((class_4538)world, pos.method_10084())) {
            world.method_8501(pos.method_10084(), class_2246.field_10477.method_9564());
        } else {
            return false;
        }
        return true;
    }

    public static boolean isBlockPassable(class_1937 world, class_2338 checkPos) {
        return world.method_22347(checkPos) || world.method_8320(checkPos).method_45474();
    }

    @FunctionalInterface
    public static interface SurfaceCriteria {
        public static final SurfaceCriteria COLLIDABLE = SurfaceCriteria.basedOn(class_4970.class_4971::method_51366);
        public static final SurfaceCriteria BUILDABLE = (world, pos, side) -> world.method_8320(pos).method_26206((class_1922)world, pos, side) && world.method_8320(pos.method_10093(side)).method_45474();
        public static final SurfaceCriteria SOLID_LIQUID_TO_AIR = (world, pos, side) -> world.method_8320(pos).method_51176() || world.method_8320(pos).method_26206((class_1922)world, pos, side) && world.method_22347(pos.method_10093(side));
        public static final SurfaceCriteria NOT_AIR_TO_AIR = SurfaceCriteria.basedOn(class_4538::method_22347).flip();

        public static SurfaceCriteria basedOn(BiPredicate<class_1937, class_2338> condition) {
            return (world, pos, side) -> condition.test(world, pos) && !condition.test(world, pos.method_10093(side));
        }

        public static SurfaceCriteria basedOn(Predicate<class_2680> condition) {
            return (world, pos, side) -> condition.test(world.method_8320(pos)) && !condition.test(world.method_8320(pos.method_10093(side)));
        }

        public boolean test(class_1937 var1, class_2338 var2, class_2350 var3);

        default public SurfaceCriteria flip() {
            return (world, pos, side) -> this.test(world, pos.method_10093(side), side.method_10153());
        }
    }
}

