/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class DrawingUtils {
    public static void drawTexturedRectF(class_4587 poseStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        DrawingUtils.drawTexturedFlippedRectF(poseStack, x, y, u, v, width, height, textureWidth, textureHeight, false, false);
    }

    public static void drawTexturedFlippedRectF(class_4587 poseStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight, boolean flipX, boolean flipY) {
        RenderSystem.setShader(class_757::method_34542);
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        float u1 = flipX ? u + width : u;
        float u2 = flipX ? u : u + width;
        float v1 = flipY ? v + height : v;
        float v2 = flipY ? v : v + height;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(poseStack.method_23760().method_23761(), x, y + height, 0.0f).method_22913(u1 * f, v2 * f1).method_1344();
        buffer.method_22918(poseStack.method_23760().method_23761(), x + width, y + height, 0.0f).method_22913(u2 * f, v2 * f1).method_1344();
        buffer.method_22918(poseStack.method_23760().method_23761(), x + width, y, 0.0f).method_22913(u2 * f, v1 * f1).method_1344();
        buffer.method_22918(poseStack.method_23760().method_23761(), x, y, 0.0f).method_22913(u1 * f, v1 * f1).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }

    public static float smoothScaleFactor(int lifetime, int ticksExisted, float partialTicks, int startLength, int endLength) {
        float age = (float)ticksExisted + partialTicks;
        float s = class_3532.method_15363((float)(age < (float)startLength || lifetime < 0 ? age / (float)startLength : ((float)lifetime - age) / (float)endLength), (float)0.0f, (float)1.0f);
        s = (float)Math.pow(s, 0.4);
        return s;
    }

    public static int mix(int colour1, int colour2, float proportion) {
        proportion = class_3532.method_15363((float)proportion, (float)0.0f, (float)1.0f);
        int r1 = colour1 >> 16 & 0xFF;
        int g1 = colour1 >> 8 & 0xFF;
        int b1 = colour1 & 0xFF;
        int r2 = colour2 >> 16 & 0xFF;
        int g2 = colour2 >> 8 & 0xFF;
        int b2 = colour2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * proportion);
        int g = (int)((float)g1 + (float)(g2 - g1) * proportion);
        int b = (int)((float)b1 + (float)(b2 - b1) * proportion);
        return (r << 16) + (g << 8) + b;
    }

    public static void drawGlitchRect(Random random, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, boolean flipX, boolean flipY) {
        for (int i = 0; i < height; ++i) {
            if (flipY) {
                i = height - i - 1;
            }
            int offset = random.nextInt(4) == 0 ? random.nextInt(6) - 3 : 0;
            DrawingUtils.drawTexturedFlippedRect(x + offset, y + i, u, v + i, width, 1, textureWidth, textureHeight, flipX, flipY);
        }
    }

    public static void drawTexturedFlippedRect(float x, float y, int u, int v, int width, int height, int textureWidth, int textureHeight, boolean flipX, boolean flipY) {
        class_4587 stack = new class_4587();
        RenderSystem.setShader(class_757::method_34542);
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        int u1 = flipX ? u + width : u;
        int u2 = flipX ? u : u + width;
        int v1 = flipY ? v + height : v;
        int v2 = flipY ? v : v + height;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(stack.method_23760().method_23761(), x, y + (float)height, 0.0f).method_22913((float)u1 * f, (float)v2 * f1).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x + (float)width, y + (float)height, 0.0f).method_22913((float)u2 * f, (float)v2 * f1).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x + (float)width, y, 0.0f).method_22913((float)u2 * f, (float)v1 * f1).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x, y, 0.0f).method_22913((float)u1 * f, (float)v1 * f1).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }

    public static void drawTexturedRect(float x, float y, int width, int height) {
        DrawingUtils.drawTexturedRect(x, y, 0, 0, width, height, width, height);
    }

    public static void drawTexturedRect(float x, float y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        DrawingUtils.drawTexturedFlippedRect(x, y, u, v, width, height, textureWidth, textureHeight, false, false);
    }

    public static int makeTranslucent(int colour, float opacity) {
        return colour + ((int)(opacity * 255.0f) << 24);
    }

    public static void drawScaledStringToWidth(class_332 guiGraphics, class_327 font, class_2561 text, float x, float y, float scale, int colour, float width, boolean centre, boolean alignR) {
        float textWidth = (float)font.method_27525((class_5348)text) * scale;
        Objects.requireNonNull(font);
        float textHeight = 9.0f * scale;
        if (textWidth > width) {
            scale *= width / textWidth;
            font.method_27525((class_5348)text);
        } else if (alignR) {
            x += width - textWidth;
        }
        if (centre) {
            Objects.requireNonNull(font);
            y += (9.0f - textHeight) / 2.0f;
        }
        DrawingUtils.drawScaledTranslucentString(guiGraphics, font, text, x, y, scale, colour);
    }

    public static void drawScaledTranslucentString(class_332 guiGraphics, class_327 font, class_2561 text, float x, float y, float scale, int colour) {
        class_4587 stack = guiGraphics.method_51448();
        stack.method_22903();
        RenderSystem.enableBlend();
        stack.method_22905(scale, scale, scale);
        float adjustedX = x / scale;
        float adjustedY = y / scale;
        guiGraphics.method_27535(font, text, (int)adjustedX, (int)adjustedY, colour);
        RenderSystem.disableBlend();
        stack.method_22909();
    }
}

