/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.entity.living.ISpellCaster;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.content.item.ScrollItem;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.google.common.collect.Streams;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static void undoGravity(class_1297 entity) {
        if (!entity.method_5740()) {
            double gravity = 0.04;
            if (entity instanceof class_1682) {
                gravity = 0.03;
            } else if (entity instanceof class_1667) {
                gravity = 0.05;
            } else if (entity instanceof class_1309) {
                gravity = 0.08;
            }
            entity.method_18799(entity.method_18798().method_1031(0.0, gravity, 0.0));
        }
    }

    @Nullable
    public static class_1297 getEntityByUUID(class_1937 world, @Nullable UUID id) {
        if (id == null) {
            return null;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (class_1297 entity : serverWorld.method_27909()) {
                if (!entity.method_5667().equals(id)) continue;
                return entity;
            }
        }
        return null;
    }

    public static List<class_1309> getLivingEntitiesInRange(class_1937 world, double x, double y, double z, double range) {
        return EntityUtil.getEntitiesInRange(world, x, y, z, range, class_1309.class);
    }

    public static List<class_1309> getLivingWithinRadius(double radius, double x, double y, double z, class_1937 world) {
        return EntityUtil.getEntitiesWithinRadius(radius, x, y, z, world, class_1309.class);
    }

    public static <T extends class_1297> List<T> getEntitiesInRange(class_1937 world, double x, double y, double z, double range, Class<T> entityClass) {
        class_238 boundingBox = new class_238(x - range, y - range, z - range, x + range, y + range, z + range);
        Predicate<class_1297> alwaysTrue = entity -> true;
        List entities = world.method_8390(entityClass, boundingBox, alwaysTrue);
        double rangeSq = range * range;
        entities.removeIf(entity -> entity.method_5649(x, y, z) > rangeSq);
        return entities;
    }

    public static <T extends class_1297> List<T> getEntitiesWithinRadius(double radius, double x, double y, double z, class_1937 world, Class<T> entityType) {
        class_238 box = new class_238(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entityList = world.method_18467(entityType, box);
        double radiusSq = radius * radius;
        entityList.removeIf(entity -> entity.method_5649(x, y, z) > radiusSq);
        return entityList;
    }

    public static boolean isLiving(class_1297 entity) {
        return entity instanceof class_1309 && !(entity instanceof class_1531);
    }

    public static boolean attackEntityWithoutKnockback(class_1297 entity, class_1282 source, float amount) {
        class_243 originalVec = entity.method_18798();
        boolean succeeded = entity.method_5643(source, amount);
        entity.method_18799(originalVec);
        return succeeded;
    }

    @Nullable
    public static class_1297 getRider(class_1297 entity) {
        return !entity.method_5685().isEmpty() ? (class_1297)entity.method_5685().get(0) : null;
    }

    public static class_243 findSpaceForTeleport(class_1297 entity, class_243 destination, boolean accountForPassengers) {
        class_1937 world = entity.method_37908();
        class_238 box = entity.method_5829();
        if (accountForPassengers) {
            for (class_1297 passenger : entity.method_5685()) {
                box = box.method_991(passenger.method_5829());
            }
        }
        box = box.method_997(destination.method_1023(entity.method_23317(), entity.method_23318(), entity.method_23321()));
        Iterable cuboid = class_2338.method_10094((int)class_3532.method_15357((double)box.field_1323), (int)class_3532.method_15357((double)box.field_1322), (int)class_3532.method_15357((double)box.field_1321), (int)class_3532.method_15357((double)box.field_1320), (int)class_3532.method_15357((double)box.field_1325), (int)class_3532.method_15357((double)box.field_1324));
        if (Streams.stream((Iterable)cuboid).allMatch(b -> world.method_18026(new class_238(b)))) {
            return destination;
        }
        double dx = box.field_1320 - box.field_1323;
        double dy = box.field_1325 - box.field_1322;
        double dz = box.field_1324 - box.field_1321;
        int nx = class_3532.method_15384((double)dx) / 2;
        int px = class_3532.method_15384((double)dx) - nx;
        int ny = class_3532.method_15384((double)dy) / 2;
        int py = class_3532.method_15384((double)dy) - ny;
        int nz = class_3532.method_15384((double)dz) / 2;
        int pz = class_3532.method_15384((double)dz) - nz;
        List nearby = Streams.stream((Iterable)class_2338.method_10094((int)(class_3532.method_15357((double)box.field_1323) - 1), (int)(class_3532.method_15357((double)box.field_1322) - 1), (int)(class_3532.method_15357((double)box.field_1321) - 1), (int)(class_3532.method_15357((double)box.field_1320) + 1), (int)(class_3532.method_15357((double)box.field_1325) + 1), (int)(class_3532.method_15357((double)box.field_1324) + 1))).collect(Collectors.toList());
        List possiblePositions = Streams.stream((Iterable)cuboid).collect(Collectors.toList());
        while (!nearby.isEmpty()) {
            class_2338 pos = (class_2338)nearby.remove(0);
            if (world.method_18026(new class_238(pos))) continue;
            Predicate<class_2338> nearSolidBlock = b -> b.method_10263() >= pos.method_10263() - nx && b.method_10263() <= pos.method_10263() + px && b.method_10264() >= pos.method_10264() - ny && b.method_10264() <= pos.method_10264() + py && b.method_10260() >= pos.method_10260() - nz && b.method_10260() <= pos.method_10260() + pz;
            nearby.removeIf(nearSolidBlock);
            possiblePositions.removeIf(nearSolidBlock);
        }
        if (possiblePositions.isEmpty()) {
            return null;
        }
        class_2338 nearest = possiblePositions.stream().min(Comparator.comparingDouble(b -> destination.method_1028((double)b.method_10263() + 0.5, (double)b.method_10264() + 0.5, (double)b.method_10260() + 0.5))).get();
        return GeometryUtil.getFaceCentre(nearest, class_2350.field_11033);
    }

    public static List<class_1309> getLivingWithinCylinder(double radius, double x, double y, double z, double height, class_1937 world) {
        return EntityUtil.getEntitiesWithinCylinder(radius, x, y, z, height, world, class_1309.class);
    }

    public static <T extends class_1297> List<T> getEntitiesWithinCylinder(double radius, double x, double y, double z, double height, class_1937 world, Class<T> entityType) {
        class_238 aabb = new class_238(x - radius, y, z - radius, x + radius, y + height, z + radius);
        List entityList = world.method_18467(entityType, aabb);
        double radiusSq = radius * radius;
        entityList.removeIf(entity -> entity.method_5649(x, entity.field_6036, z) > radiusSq);
        return entityList;
    }

    public static boolean canDamageBlocks(class_1309 entity, class_1937 world) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return player.method_7294() && !player.method_7325();
        }
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            return !Services.PLATFORM.fireMobBlockBreakEvent(world, null, mob);
        }
        return false;
    }

    public static int getDefaultAimingError(class_1267 difficulty) {
        return switch (difficulty) {
            case class_1267.field_5805 -> 5;
            case class_1267.field_5802 -> 3;
            case class_1267.field_5807 -> 0;
            default -> 4;
        };
    }

    public static void playSoundAtPlayer(class_1657 player, class_3414 sound, float volume, float pitch) {
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), sound, class_3419.field_15248, volume, pitch);
    }

    public static boolean isCasting(class_1309 caster, Spell spell) {
        if (spell.isInstantCast()) {
            return false;
        }
        if (caster instanceof class_1657) {
            if (caster.method_6115()) {
                class_1799 stack = caster.method_5998(caster.method_6058());
                boolean isSpellCastingItem = stack.method_7909() instanceof ISpellCastingItem;
                if (!isSpellCastingItem) {
                    return false;
                }
                Spell currentSpell = ((ISpellCastingItem)stack.method_7909()).getCurrentSpell(stack);
                if (stack.method_7909() instanceof ScrollItem) {
                    return currentSpell == spell;
                }
                int ticksInUse = caster.method_6030().method_7935() - caster.method_6014();
                if (ticksInUse >= spell.getCharge()) {
                    return currentSpell == spell;
                }
            }
        } else if (caster instanceof ISpellCaster) {
            ISpellCaster spellCaster = (ISpellCaster)caster;
            return spellCaster.getContinuousSpell() == spell;
        }
        return false;
    }

    public static SpellTier populateSpells(List<Spell> spells, Element e, boolean master, int n, class_5819 random) {
        SpellTier maxTier = SpellTiers.NOVICE;
        List<Spell> npcSpells = SpellUtil.getSpells(Spell::canCastByEntity);
        for (int i = 0; i < n; ++i) {
            Element element = e == Elements.MAGIC ? SpellUtil.getRandomElement(random) : e;
            int randomizer = random.method_43048(20);
            SpellTier tier = randomizer < 10 ? SpellTiers.NOVICE : (randomizer < 16 ? SpellTiers.APPRENTICE : (randomizer < 19 || !master ? SpellTiers.ADVANCED : SpellTiers.MASTER));
            if (tier.level > maxTier.level) {
                maxTier = tier;
            }
            List<Spell> list = SpellUtil.getSpells(spell -> spell.getTier() == tier && spell.getElement() == element && spell.canCastByEntity() && spell.isEnabled(SpellContext.NPCS));
            list.retainAll(npcSpells);
            list.removeAll(spells);
            if (list.isEmpty()) {
                list = npcSpells;
                list.removeAll(spells);
            }
            if (list.isEmpty()) continue;
            spells.add(list.get(random.method_43048(list.size())));
        }
        return maxTier;
    }

    public static class_1799 getWandInUse(class_1657 player) {
        class_1799 wand = player.method_6047();
        if (!(wand.method_7909() instanceof ISpellCastingItem && ((ISpellCastingItem)wand.method_7909()).getSpells(wand).length >= 2 || (wand = player.method_6079()).method_7909() instanceof ISpellCastingItem && ((ISpellCastingItem)wand.method_7909()).getSpells(wand).length >= 2)) {
            return null;
        }
        return wand;
    }

    public static void applyStandardKnockback(class_1297 attacker, class_1309 target, float strength) {
        double dx = attacker.method_23317() - target.method_23317();
        double dz = attacker.method_23321() - target.method_23321();
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        target.method_6005((double)strength, dx, dz);
    }
}

