/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.content.item.WizardArmorItem;
import com.binaris.wizardry.content.item.WizardArmorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public final class InventoryUtil {
    public static final class_1304[] ARMOR_SLOTS;

    public static Collection<class_1799> getAllItems(class_1657 player) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        items.addAll((Collection<class_1799>)player.method_31548().field_7547);
        items.addAll((Collection<class_1799>)player.method_31548().field_7548);
        items.addAll((Collection<class_1799>)player.method_31548().field_7544);
        return items;
    }

    public static List<class_1799> getHotBarAndOffhand(class_1657 player) {
        List<class_1799> hotbar = InventoryUtil.getHotbar(player);
        hotbar.add(0, player.method_6079());
        hotbar.remove(player.method_6047());
        hotbar.add(0, player.method_6047());
        return hotbar;
    }

    public static boolean doesPlayerHaveItem(class_1657 player, class_1792 item) {
        for (class_1799 stack : InventoryUtil.getAllItems(player)) {
            if (stack == null || !stack.method_31574(item)) continue;
            return true;
        }
        return false;
    }

    public static List<class_1799> getHotbar(class_1657 player) {
        class_2371 hotBar = class_2371.method_10211();
        hotBar.addAll((Collection)player.method_31548().field_7547.subList(0, 9));
        return hotBar;
    }

    public static boolean isWearingFullSet(class_1309 entity, @Nullable Element element, @Nullable WizardArmorType armor) {
        class_1799 helmet = entity.method_6118(class_1304.field_6169);
        class_1792 class_17922 = helmet.method_7909();
        if (!(class_17922 instanceof WizardArmorItem)) {
            return false;
        }
        WizardArmorItem wizardArmor = (WizardArmorItem)class_17922;
        Element e = element == null ? wizardArmor.getElement() : element;
        WizardArmorType ac = armor == null ? wizardArmor.getWizardArmorType() : armor;
        return Arrays.stream(ARMOR_SLOTS).allMatch(slot -> {
            WizardArmorItem armor2;
            class_1792 patt2768$temp = entity.method_6118(slot).method_7909();
            return patt2768$temp instanceof WizardArmorItem && (armor2 = (WizardArmorItem)patt2768$temp).getElement() == e && armor2.getWizardArmorType() == ac;
        });
    }

    public static boolean doAllArmourPiecesHaveMana(class_1309 entity) {
        return Arrays.stream(ARMOR_SLOTS).noneMatch(s -> {
            IManaStoringItem manaStoringItem;
            class_1792 patt3090$temp = entity.method_6118(s).method_7909();
            return patt3090$temp instanceof IManaStoringItem && (manaStoringItem = (IManaStoringItem)patt3090$temp).isManaEmpty(entity.method_6118(s));
        });
    }

    static {
        ArrayList<class_1304> slots = new ArrayList<class_1304>(Arrays.asList(class_1304.values()));
        slots.removeIf(slot -> slot.method_5925() != class_1304.class_1305.field_6178);
        ARMOR_SLOTS = slots.toArray(new class_1304[0]);
    }
}

