/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.content.entity.living.IceGiant;
import com.binaris.wizardry.content.entity.living.IceWraith;
import com.binaris.wizardry.content.entity.living.LightningWraith;
import com.binaris.wizardry.content.entity.living.ShadowWraith;
import com.binaris.wizardry.content.entity.living.StormElemental;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1456;
import net.minecraft.class_1473;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1549;
import net.minecraft.class_1571;
import net.minecraft.class_1589;
import net.minecraft.class_1590;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_5321;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8046;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

public class MagicDamageSource
extends class_1282 {
    private static final Map<Class<? extends class_1297>, Set<class_5321<class_8110>>> IMMUNITY_MAPPING = new HashMap<Class<? extends class_1297>, Set<class_5321<class_8110>>>();

    public MagicDamageSource(class_6880<class_8110> damageTypeHolder, @Nullable class_1297 directEntity, @Nullable class_1297 causingEntity) {
        super(damageTypeHolder, directEntity, causingEntity);
    }

    @SafeVarargs
    public static void setEntityImmunities(Class<? extends class_1297> entityType, class_5321<class_8110> ... immunities) {
        IMMUNITY_MAPPING.computeIfAbsent(entityType, k -> new HashSet()).addAll(Arrays.asList(immunities));
    }

    public static boolean isEntityImmune(class_5321<class_8110> type, class_1297 entity) {
        if (type == EBDamageSources.FIRE && entity.method_5753()) {
            return true;
        }
        Set<class_5321<class_8110>> immunities = IMMUNITY_MAPPING.get(entity.getClass());
        return immunities != null && immunities.contains(type);
    }

    public static boolean causeMagicDamage(class_1297 caster, class_1297 target, float damage, class_5321<class_8110> type) {
        class_1297 owner = MagicDamageSource.getOwnerIfPresent(caster);
        class_1282 source = owner != null ? MagicDamageSource.causeIndirectMagicDamage(caster, owner, type) : MagicDamageSource.causeDirectMagicDamage(caster, type);
        return target.method_5643(source, damage);
    }

    @Nullable
    private static class_1297 getOwnerIfPresent(class_1297 entity) {
        class_8046 traceable;
        class_6025 ownable;
        if (entity instanceof class_6025 && (ownable = (class_6025)entity).method_35057() != null) {
            return ownable.method_35057();
        }
        if (entity instanceof class_8046 && (traceable = (class_8046)entity).method_24921() != null) {
            return traceable.method_24921();
        }
        return null;
    }

    public static class_1282 causeDirectMagicDamage(class_1297 caster, class_5321<class_8110> type) {
        return MagicDamageSource.createMagicDamage(caster, null, type);
    }

    public static class_1282 causeIndirectMagicDamage(class_1297 magic, class_1297 caster, class_5321<class_8110> type) {
        return MagicDamageSource.createMagicDamage(magic, caster, type);
    }

    private static class_1282 createMagicDamage(class_1297 source, class_1297 indirect, class_5321<class_8110> type) {
        class_6880.class_6883 holder = source.method_37908().method_30349().method_46762(class_7924.field_42534).method_46747(type);
        return new MagicDamageSource((class_6880<class_8110>)holder, source, indirect);
    }

    static {
        MagicDamageSource.setEntityImmunities(class_1545.class, EBDamageSources.FIRE);
        MagicDamageSource.setEntityImmunities(class_1590.class, EBDamageSources.FIRE, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(class_1589.class, EBDamageSources.FIRE);
        MagicDamageSource.setEntityImmunities(class_1571.class, EBDamageSources.FIRE);
        MagicDamageSource.setEntityImmunities(class_1510.class, EBDamageSources.FIRE);
        MagicDamageSource.setEntityImmunities(class_1528.class, EBDamageSources.FIRE, EBDamageSources.WITHER);
        MagicDamageSource.setEntityImmunities(class_1473.class, EBDamageSources.FROST);
        MagicDamageSource.setEntityImmunities(class_1456.class, EBDamageSources.FROST);
        MagicDamageSource.setEntityImmunities(class_1639.class, EBDamageSources.WITHER);
        MagicDamageSource.setEntityImmunities(class_1628.class, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(class_1549.class, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(class_1642.class, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(class_1613.class, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(IceWraith.class, EBDamageSources.FROST);
        MagicDamageSource.setEntityImmunities(IceGiant.class, EBDamageSources.FROST);
        MagicDamageSource.setEntityImmunities(LightningWraith.class, EBDamageSources.SHOCK);
        MagicDamageSource.setEntityImmunities(ShadowWraith.class, EBDamageSources.WITHER);
        MagicDamageSource.setEntityImmunities(StormElemental.class, EBDamageSources.FIRE, EBDamageSources.SHOCK);
    }
}

