/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.EBLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public final class NBTExtras {
    private NBTExtras() {
    }

    public static void storeTagSafely(class_2487 compound, String key, class_2520 tag) {
        if (compound == tag || NBTExtras.deepContains(tag, (class_2520)compound)) {
            EBLogger.error("Cannot store tag of type %s under key '{}' as it would result in a circular reference! Please report this (including your full log) to wizardry's issue tracker.", NBTExtras.getTagTypeName(tag.method_10711()), key);
        } else {
            compound.method_10566(key, tag);
        }
    }

    public static boolean deepContains(class_2520 toSearch, class_2520 searchFor) {
        block3: {
            block2: {
                if (!(toSearch instanceof class_2487)) break block2;
                for (String subKey : ((class_2487)toSearch).method_10541()) {
                    class_2520 subTag = ((class_2487)toSearch).method_10580(subKey);
                    if (subTag != searchFor && !NBTExtras.deepContains(subTag, searchFor)) continue;
                    return true;
                }
                break block3;
            }
            if (!(toSearch instanceof class_2499)) break block3;
            for (class_2520 subTag : (class_2499)toSearch) {
                if (subTag != searchFor && !NBTExtras.deepContains(subTag, searchFor)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getTagTypeName(int id) {
        return switch (id) {
            case 0 -> "TAG_End";
            case 1 -> "TAG_Byte";
            case 2 -> "TAG_Short";
            case 3 -> "TAG_Int";
            case 4 -> "TAG_Long";
            case 5 -> "TAG_Float";
            case 6 -> "TAG_Double";
            case 7 -> "TAG_Byte_Array";
            case 8 -> "TAG_String";
            case 9 -> "TAG_List";
            case 10 -> "TAG_Compound";
            case 11 -> "TAG_Int_Array";
            case 12 -> "TAG_Long_Array";
            case 99 -> "Any Numeric Tag";
            default -> "UNKNOWN";
        };
    }

    public static <E, T extends class_2520> class_2499 listToTag(Collection<E> list, Function<E, T> mapper) {
        class_2499 tagList = new class_2499();
        for (E element : list) {
            tagList.add((Object)((class_2520)mapper.apply(element)));
        }
        return tagList;
    }

    public static <E, T extends class_2520> Collection<E> tagToList(class_2499 tagList, Function<T, E> function) {
        ArrayList<E> list = new ArrayList<E>();
        class_2499 tagList2 = tagList.method_10612();
        while (!tagList2.isEmpty()) {
            class_2520 tag = tagList2.method_10536(0);
            try {
                list.add(function.apply(tag));
            }
            catch (ClassCastException e) {
                EBLogger.error("Error when reading list from NBT: unexpected tag type " + NBTExtras.getTagTypeName(tag.method_10711()), e);
            }
        }
        return list;
    }
}

