/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.entity.ICustomHitbox;
import com.binaris.wizardry.api.content.util.EntityUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RayTracer {
    @NotNull
    public static class_239 rayTrace(class_1937 world, class_1297 caster, class_243 origin, class_243 endpoint, float aimAssist, boolean hitLiquids, Class<? extends class_1297> entityType, Predicate<? super class_1297> filter) {
        class_3959.class_242 fluidMode = hitLiquids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348;
        class_3965 blockHit = world.method_17742(new class_3959(origin, endpoint, class_3959.class_3960.field_17558, fluidMode, caster));
        class_243 traceEnd = blockHit.method_17784();
        float searchRadius = 1.0f + aimAssist;
        class_238 searchVolume = new class_238(origin.field_1352, origin.field_1351, origin.field_1350, traceEnd.field_1352, traceEnd.field_1351, traceEnd.field_1350).method_1009((double)searchRadius, (double)searchRadius, (double)searchRadius);
        List entities = world.method_18467(entityType, searchVolume);
        entities.removeIf(filter);
        class_1297 closestEntity = null;
        double closestDistance = origin.method_1022(traceEnd);
        for (class_1297 entity : entities) {
            double distance;
            class_243 intercept = RayTracer.calculateIntercept(entity, origin, traceEnd, aimAssist);
            if (intercept == null || !((distance = origin.method_1022(intercept)) < closestDistance)) continue;
            closestEntity = entity;
            closestDistance = distance;
        }
        return closestEntity != null ? new class_3966(closestEntity) : blockHit;
    }

    @Nullable
    private static class_243 calculateIntercept(class_1297 entity, class_243 origin, class_243 endpoint, float aimAssist) {
        if (entity instanceof ICustomHitbox) {
            ICustomHitbox customHitbox = (ICustomHitbox)entity;
            float fuzziness = EntityUtil.isLiving(entity) ? aimAssist : 0.0f;
            return customHitbox.calculateIntercept(origin, endpoint, fuzziness);
        }
        class_238 bounds = entity.method_5829();
        float pickRadius = entity.method_5871();
        if (pickRadius != 0.0f) {
            bounds = bounds.method_1014((double)pickRadius);
        }
        if (EntityUtil.isLiving(entity) && aimAssist != 0.0f) {
            bounds = bounds.method_1014((double)aimAssist);
        }
        return bounds.method_992(origin, endpoint).orElse(null);
    }

    @NotNull
    public static class_239 standardBlockRayTrace(class_1937 world, class_1309 entity, double range, boolean hitLiquids, boolean ignoreUncollidables, boolean returnLastUncollidable) {
        class_243 origin = entity.method_5836(1.0f);
        class_243 endpoint = origin.method_1019(entity.method_5720().method_1021(range));
        class_3959.class_242 fluidMode = hitLiquids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348;
        return world.method_17742(new class_3959(origin, endpoint, class_3959.class_3960.field_17558, fluidMode, (class_1297)entity));
    }

    public static Predicate<class_1297> ignoreEntityFilter(@Nullable class_1297 entity) {
        return e -> {
            if (e == entity) return true;
            if (!(e instanceof class_1309)) return false;
            class_1309 living = (class_1309)e;
            if (living.field_6213 <= 0) return false;
            return true;
        };
    }
}

