/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public final class SpellUtil {
    public static String SPELL_KEY = "Spell";

    private SpellUtil() {
    }

    public static List<Spell> getSpells(Predicate<Spell> filter) {
        return Services.REGISTRY_UTIL.getSpells().stream().filter(filter.and(s -> s != Spells.NONE)).collect(Collectors.toList());
    }

    public static Element getRandomElement(class_5819 random) {
        return Services.REGISTRY_UTIL.getElements().stream().toList().get(random.method_43048(Services.REGISTRY_UTIL.getElements().size()));
    }

    public static class_1799 setSpell(class_1799 stack, Spell spell) {
        stack.method_7948().method_10582(SPELL_KEY, spell.getLocation().toString());
        return stack;
    }

    public static class_1799 spellBookItem(Spell spell) {
        class_1799 stack = new class_1799((class_1935)EBItems.SPELL_BOOK.get(), 1);
        SpellUtil.setSpell(stack, spell);
        return stack;
    }

    public static class_1799 wandItem(SpellTier tier, Element element) {
        return new class_1799((class_1935)RegistryUtils.getWand(tier, element));
    }

    public static class_1799 arcaneTomeItem(SpellTier tier) {
        class_1799 stack = new class_1799((class_1935)EBItems.ARCANE_TOME.get());
        stack.method_7948().method_10582("Tier", tier.getOrCreateLocation().toString());
        return stack;
    }

    @NotNull
    public static Spell getSpell(class_1799 stack) {
        return SpellUtil.getSpellFromNbt(stack.method_7948());
    }

    private static Spell getSpellFromNbt(class_2487 tag) {
        Spell byId = SpellUtil.byId(tag.method_10558(SPELL_KEY));
        return byId == null ? Spells.NONE : byId;
    }

    private static Spell byId(String id) {
        return Services.REGISTRY_UTIL.getSpell(class_2960.method_12829((String)id));
    }
}

