/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.item.IElementValue;
import com.binaris.wizardry.api.content.item.ITierValue;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.core.EBConstants;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public final class WandHelper {
    public static final String SPELL_ARRAY_KEY = "spells";
    public static final String SELECTED_SPELL_KEY = "selectedSpell";
    public static final String COOLDOWN_END_TIME_ARRAY_KEY = "cooldownEndTime";
    public static final String MAX_COOLDOWN_ARRAY_KEY = "maxCooldown";
    public static final String UPGRADES_KEY = "upgrades";
    public static final String PROGRESSION_KEY = "progression";
    private static final float SECOND_TIME_PROGRESSION_MODIFIER = 1.5f;

    private WandHelper() {
    }

    public static List<Spell> getSpells(class_1799 wand) {
        int maxSlots;
        class_1792 class_17922;
        ArrayList<Spell> spells = new ArrayList<Spell>();
        class_2487 tag = wand.method_7948();
        if (tag.method_10545(SPELL_ARRAY_KEY)) {
            class_2499 list = tag.method_10554(SPELL_ARRAY_KEY, 8);
            for (class_2520 element : list) {
                class_2519 stringTag;
                class_2960 location;
                if (!(element instanceof class_2519) || (location = class_2960.method_12829((String)(stringTag = (class_2519)element).method_10714())) == null) continue;
                spells.add(Services.REGISTRY_UTIL.getSpell(location));
            }
        }
        if ((class_17922 = wand.method_7909()) instanceof WandItem) {
            WandItem wandItem = (WandItem)class_17922;
            v0 = wandItem.getSpellSlotCount(wand);
        } else {
            v0 = maxSlots = 5;
        }
        while (spells.size() < maxSlots) {
            spells.add(Spells.NONE);
        }
        return spells;
    }

    public static void setSpells(class_1799 wand, Collection<Spell> spells) {
        class_2499 list = new class_2499();
        spells.forEach(spell -> list.add((Object)class_2519.method_23256((String)spell.getLocation().toString())));
        wand.method_7948().method_10566(SPELL_ARRAY_KEY, (class_2520)list);
    }

    public static Spell getCurrentSpell(class_1799 wand) {
        String tag = wand.method_7948().method_10558(SELECTED_SPELL_KEY);
        Spell spell = Services.REGISTRY_UTIL.getSpell(class_2960.method_12829((String)tag));
        return spell != null ? spell : Spells.NONE;
    }

    public static void setCurrentSpell(class_1799 wand, Spell spell) {
        wand.method_7948().method_10582(SELECTED_SPELL_KEY, spell.getLocation().toString());
    }

    public static Spell getNextSpell(class_1799 wand) {
        return WandHelper.getAdjacentSpell(wand, 1);
    }

    public static Spell getPreviousSpell(class_1799 wand) {
        return WandHelper.getAdjacentSpell(wand, -1);
    }

    private static Spell getAdjacentSpell(class_1799 wand, int offset) {
        List<Spell> spells = WandHelper.getSpells(wand);
        if (spells.isEmpty()) {
            return Spells.NONE;
        }
        int currentIndex = spells.indexOf(WandHelper.getCurrentSpell(wand));
        if (currentIndex == -1) {
            return spells.get(0);
        }
        int newIndex = (currentIndex + offset + spells.size()) % spells.size();
        return spells.get(newIndex);
    }

    public static boolean selectSpell(class_1799 wand, int index) {
        List<Spell> spells = WandHelper.getSpells(wand);
        if (spells.isEmpty()) {
            return false;
        }
        WandHelper.setCurrentSpell(wand, spells.get(index));
        return true;
    }

    public static long[] getCooldownEndTimes(class_1799 wand) {
        return wand.method_7948().method_10565(COOLDOWN_END_TIME_ARRAY_KEY);
    }

    public static void setCooldownEndTimes(class_1799 wand, long[] cooldownEndTimes) {
        wand.method_7948().method_10564(COOLDOWN_END_TIME_ARRAY_KEY, cooldownEndTimes);
    }

    public static int getCurrentCooldown(class_1799 wand, long currentGameTime) {
        long endTime;
        long[] endTimes = WandHelper.getCooldownEndTimes(wand);
        int selectedSpellIndex = WandHelper.getSpells(wand).indexOf(WandHelper.getCurrentSpell(wand));
        if (selectedSpellIndex >= 0 && selectedSpellIndex < endTimes.length && (endTime = endTimes[selectedSpellIndex]) > currentGameTime) {
            return (int)(endTime - currentGameTime);
        }
        return 0;
    }

    public static void setCurrentCooldown(class_1799 wand, int cooldown, long currentGameTime) {
        int spellCount;
        int selectedSpell = WandHelper.getSpells(wand).indexOf(WandHelper.getCurrentSpell(wand));
        if (selectedSpell >= (spellCount = WandHelper.getSpells(wand).size())) {
            return;
        }
        long[] endTimes = WandHelper.getCooldownEndTimes(wand);
        if (endTimes.length <= selectedSpell) {
            endTimes = new long[spellCount];
        }
        endTimes[selectedSpell] = currentGameTime + (long)Math.max(1, cooldown);
        WandHelper.setCooldownEndTimes(wand, endTimes);
        int[] maxCooldowns = WandHelper.getMaxCooldowns(wand);
        if (maxCooldowns.length <= selectedSpell) {
            maxCooldowns = new int[spellCount];
        }
        maxCooldowns[selectedSpell] = Math.max(1, cooldown);
        WandHelper.setMaxCooldowns(wand, maxCooldowns);
    }

    public static int[] getMaxCooldowns(class_1799 wand) {
        return wand.method_7948().method_10561(MAX_COOLDOWN_ARRAY_KEY);
    }

    public static void setMaxCooldowns(class_1799 wand, int[] cooldowns) {
        wand.method_7948().method_10539(MAX_COOLDOWN_ARRAY_KEY, cooldowns);
    }

    public static int getCurrentMaxCooldown(class_1799 wand) {
        int[] cooldowns = WandHelper.getMaxCooldowns(wand);
        int selectedSpell = WandHelper.getSpells(wand).indexOf(WandHelper.getCurrentSpell(wand));
        return selectedSpell >= 0 && selectedSpell < cooldowns.length ? cooldowns[selectedSpell] : 0;
    }

    public static int getUpgradeLevel(class_1799 wand, class_1792 upgrade) {
        for (Map.Entry<class_1792, String> entry : WandUpgrades.getWandUpgrades().entrySet()) {
            if (!entry.getKey().equals(upgrade)) continue;
            return wand.method_7948().method_10562(UPGRADES_KEY).method_10550(entry.getValue());
        }
        return 0;
    }

    public static int getTotalUpgrades(class_1799 wand) {
        return WandUpgrades.getWandUpgrades().keySet().stream().mapToInt(item -> WandHelper.getUpgradeLevel(wand, item)).sum();
    }

    public static void applyUpgrade(class_1799 wand, class_1792 upgrade) {
        class_2487 upgrades = wand.method_7948().method_10562(UPGRADES_KEY);
        if (upgrades.method_33133()) {
            upgrades = new class_2487();
        }
        for (Map.Entry<class_1792, String> entry : WandUpgrades.getWandUpgrades().entrySet()) {
            if (!entry.getKey().equals(upgrade)) continue;
            String key = entry.getValue();
            upgrades.method_10569(key, upgrades.method_10550(key) + 1);
            wand.method_7948().method_10566(UPGRADES_KEY, (class_2520)upgrades);
            return;
        }
    }

    public static int getProgression(class_1799 wand) {
        return wand.method_7948().method_10550(PROGRESSION_KEY);
    }

    public static void setProgression(class_1799 wand, int progression) {
        wand.method_7948().method_10569(PROGRESSION_KEY, progression);
    }

    public static void addProgression(class_1799 wand, int progression) {
        WandHelper.setProgression(wand, WandHelper.getProgression(wand) + progression);
    }

    public static int getDistributedCost(int cost, int castingTick) {
        int partialCost = castingTick % 20 == 0 ? cost / 2 + cost % 2 : (castingTick % 10 == 0 ? cost / 2 : 0);
        return partialCost;
    }

    public static SpellModifiers calculateModifiers(class_1799 stack, class_1657 player, Spell spell) {
        SpellModifiers modifiers = new SpellModifiers();
        int level = WandHelper.getUpgradeLevel(stack, EBItems.RANGE_UPGRADE.get());
        if (level > 0) {
            modifiers.set(EBItems.RANGE_UPGRADE.get(), 1.0f + (float)level * EBConstants.RANGE_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, EBItems.DURATION_UPGRADE.get())) > 0) {
            modifiers.set(EBItems.DURATION_UPGRADE.get(), 1.0f + (float)level * EBConstants.DURATION_INCREASE_PER_LEVEL, false);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, EBItems.BLAST_UPGRADE.get())) > 0) {
            modifiers.set(EBItems.BLAST_UPGRADE.get(), 1.0f + (float)level * EBConstants.BLAST_RADIUS_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, EBItems.COOLDOWN_UPGRADE.get())) > 0) {
            modifiers.set(EBItems.COOLDOWN_UPGRADE.get(), 1.0f - (float)level * EBConstants.COOLDOWN_REDUCTION_PER_LEVEL, true);
        }
        float progressionModifier = 1.0f - (float)Services.OBJECT_DATA.getWizardData(player).countRecentCasts(spell) / 5.0f * 0.75f;
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
        WizardData wizardData = Services.OBJECT_DATA.getWizardData(player);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IElementValue) {
            IElementValue elementValue = (IElementValue)class_17922;
            class_17922 = stack.method_7909();
            if (class_17922 instanceof ITierValue) {
                ITierValue tierValue = (ITierValue)class_17922;
                if (elementValue.getElement() == spell.getElement()) {
                    modifiers.set("potency", 1.0f + (float)(tierValue.getTier((class_1799)stack).level + 1) * EBConstants.POTENCY_INCREASE_PER_TIER, true);
                    progressionModifier *= 1.2f;
                }
                if (!wizardData.hasReachedTier(tierValue.getTier(stack).next())) {
                    progressionModifier *= 1.5f;
                }
            }
        }
        if (!data.hasSpellBeenDiscovered(spell)) {
            progressionModifier *= 5.0f;
        }
        modifiers.set(PROGRESSION_KEY, progressionModifier, false);
        return modifiers;
    }
}

