/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.ITierValue;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.setup.registries.SpellTiers;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public final class WorkbenchUtils {
    public static boolean rechargeManaFromCrystals(class_1735 centre, class_1735 crystals) {
        class_1799 stack = centre.method_7677();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IManaStoringItem)) {
            return false;
        }
        IManaStoringItem manaItem = (IManaStoringItem)class_17922;
        if (!crystals.method_7681() || manaItem.isManaFull(centre.method_7677())) {
            return false;
        }
        int chargeDepleted = manaItem.getManaCapacity(centre.method_7677()) - manaItem.getMana(centre.method_7677());
        int manaPerItem = WorkbenchUtils.getManaValuePerCrystal(crystals.method_7677());
        int totalAvailableMana = crystals.method_7677().method_7947() * manaPerItem;
        if (totalAvailableMana < chargeDepleted) {
            manaItem.rechargeMana(centre.method_7677(), totalAvailableMana);
            crystals.method_7671(crystals.method_7677().method_7947());
        } else {
            manaItem.setMana(centre.method_7677(), manaItem.getManaCapacity(centre.method_7677()));
            crystals.method_7671((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
        }
        return true;
    }

    public static int getManaValuePerCrystal(class_1799 crystal) {
        class_1792 class_17922 = crystal.method_7909();
        if (class_17922 instanceof IManaStoringItem) {
            IManaStoringItem manaItem = (IManaStoringItem)class_17922;
            return manaItem.getMana(crystal);
        }
        return 0;
    }

    public static boolean applySpellBooks(class_1735 centre, class_1735[] spellBooks, SpellContext ctx) {
        SpellTier spellTier;
        List<Spell> spells = WandHelper.getSpells(centre.method_7677());
        boolean changed = false;
        class_1792 class_17922 = centre.method_7677().method_7909();
        if (class_17922 instanceof ITierValue) {
            ITierValue tierItem = (ITierValue)class_17922;
            spellTier = tierItem.getTier(centre.method_7677());
        } else {
            spellTier = SpellTiers.NOVICE;
        }
        SpellTier origin = spellTier;
        for (int i = 0; i < spells.size(); ++i) {
            Spell spell;
            if (!spellBooks[i].method_7681() || !WorkbenchUtils.canBindSpell(spell = SpellUtil.getSpell(spellBooks[i].method_7677()), spells, origin, i, ctx)) continue;
            WorkbenchUtils.updateSpellSlot(centre.method_7677(), spells, i, spell);
            if (EBConfig.singleUseSpellBooks) {
                spellBooks[i].method_7677().method_7934(1);
            }
            changed = true;
        }
        if (changed) {
            WandHelper.setSpells(centre.method_7677(), spells);
        }
        return changed;
    }

    public static boolean canBindSpell(Spell spell, List<Spell> spells, SpellTier origin, int slot, SpellContext ctx) {
        return spell.getTier().level <= origin.level && spells.get(slot) != spell && spell.isEnabled(ctx) && (!EBConfig.preventBindingSameSpellTwiceToWands || spells.stream().noneMatch(s -> s == spell));
    }

    public static void updateSpellSlot(class_1799 wand, List<Spell> spells, int slot, Spell spell) {
        int currentSelectedIndex = spells.indexOf(WandHelper.getCurrentSpell(wand));
        if (currentSelectedIndex == slot) {
            WandHelper.setCurrentSpell(wand, spell);
        }
        spells.set(slot, spell);
    }

    private WorkbenchUtils() {
    }
}

