/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.cca.player;

import com.binaris.wizardry.api.content.data.CastCommandData;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.NoneSpell;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.cca.EBComponents;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Spells;
import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class CastCommandDataHolder
implements CastCommandData,
ComponentV3,
AutoSyncedComponent {
    private final class_1657 provider;
    private Spell castCommandSpell = Spells.NONE;
    private int castCommandTick;
    private SpellModifiers castCommandModifiers = new SpellModifiers();
    private int castCommandDuration;

    public CastCommandDataHolder(class_1657 provider) {
        this.provider = provider;
    }

    private void sync() {
        EBComponents.CAST_COMMAND_DATA.sync((Object)this.provider);
    }

    @Override
    public void startCastingContinuousSpell(Spell spell, SpellModifiers modifiers, int duration) {
        this.castCommandSpell = spell;
        this.castCommandModifiers = modifiers;
        this.castCommandDuration = duration;
        this.sync();
    }

    @Override
    public void stopCastingContinuousSpell() {
        this.castCommandSpell = Spells.NONE;
        this.castCommandTick = 0;
        this.castCommandModifiers.reset();
        this.sync();
    }

    @Override
    public void tick() {
        if (!this.isCommandCasting()) {
            return;
        }
        if (this.castCommandSpell == null || this.castCommandSpell instanceof NoneSpell || this.castCommandSpell.isInstantCast()) {
            this.castCommandTick = 0;
        }
        if (this.castCommandTick >= this.castCommandDuration) {
            this.stopCastingContinuousSpell();
            return;
        }
        if (WizardryEventBus.getInstance().fire(new SpellCastEvent.Tick(SpellCastEvent.Source.COMMAND, this.castCommandSpell, (class_1309)this.provider, this.castCommandModifiers, this.castCommandTick))) {
            this.stopCastingContinuousSpell();
            return;
        }
        if (this.castCommandSpell.cast(new PlayerCastContext(this.provider.method_37908(), this.provider, class_1268.field_5808, this.castCommandTick, this.castCommandModifiers)) && this.castCommandTick == 0) {
            WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, this.castCommandSpell, (class_1309)this.provider, this.castCommandModifiers));
        }
        ++this.castCommandTick;
        this.sync();
    }

    @Override
    public boolean isCommandCasting() {
        return this.castCommandSpell != null && this.castCommandSpell != Spells.NONE;
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        class_2960 spellLocation = class_2960.method_12829((String)tag.method_10558("castCommandSpell"));
        Spell spell = Services.REGISTRY_UTIL.getSpell(spellLocation);
        this.castCommandSpell = spell != null ? spell : Spells.NONE;
        this.castCommandDuration = tag.method_10550("castCommandDuration");
        this.castCommandTick = tag.method_10550("castCommandTick");
        class_2520 modifiersTag = tag.method_10580("castCommandModifiers");
        this.castCommandModifiers = modifiersTag instanceof class_2487 ? SpellModifiers.fromTag((class_2487)modifiersTag) : new SpellModifiers();
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        tag.method_10566("castCommandSpell", (class_2520)class_2519.method_23256((String)this.castCommandSpell.getLocation().toString()));
        tag.method_10569("castCommandDuration", this.castCommandDuration);
        tag.method_10569("castCommandTick", this.castCommandTick);
        tag.method_10566("castCommandModifiers", (class_2520)this.castCommandModifiers.toTag());
    }
}

