/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.cca.player;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.data.ISpellVar;
import com.binaris.wizardry.api.content.data.IStoredSpellVar;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.spell.NoneSpell;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.cca.EBComponents;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Spells;
import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class SpellManagerDataHolder
implements SpellManagerData,
ComponentV3,
AutoSyncedComponent {
    public static final Set<IStoredSpellVar> storedVariables = new HashSet<IStoredSpellVar>();
    public final Map<ISpellVar, Object> spellData = new HashMap<ISpellVar, Object>();
    private final class_1657 provider;
    public Set<Spell> spellsDiscovered = new HashSet<Spell>();

    public SpellManagerDataHolder(class_1657 provider) {
        this.provider = provider;
        this.spellsDiscovered.add(Spells.NONE);
        this.spellsDiscovered.add(Spells.MAGIC_MISSILE);
    }

    @Override
    public void sync() {
        EBComponents.SPELL_MANAGER_DATA.sync((Object)this.provider);
    }

    @Override
    public <T> T getVariable(ISpellVar<T> var) {
        return (T)this.spellData.get(var);
    }

    @Override
    public <T> void setVariable(ISpellVar<? super T> variable, T value) {
        this.spellData.put(variable, value);
    }

    @Override
    public Map<ISpellVar, Object> getSpellData() {
        return this.spellData;
    }

    @Override
    public boolean hasSpellBeenDiscovered(Spell spell) {
        return this.spellsDiscovered.contains(spell) || spell instanceof NoneSpell;
    }

    @Override
    public boolean discoverSpell(Spell spell) {
        if (spell instanceof NoneSpell) {
            return false;
        }
        boolean result = this.spellsDiscovered.add(spell);
        if (result) {
            this.sync();
        }
        return result;
    }

    @Override
    public boolean undiscoverSpell(Spell spell) {
        boolean result = this.spellsDiscovered.remove(spell);
        if (result) {
            this.sync();
        }
        return result;
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        this.spellsDiscovered.clear();
        if (tag.method_10573("spellsDiscovered", 9)) {
            class_2499 listTag = tag.method_10554("spellsDiscovered", 8);
            for (class_2520 element : listTag) {
                class_2960 location = class_2960.method_12829((String)element.method_10714());
                if (location == null) continue;
                this.spellsDiscovered.add(Services.REGISTRY_UTIL.getSpell(location));
            }
        }
        try {
            storedVariables.forEach(k -> this.spellData.put((ISpellVar)k, k.read(tag)));
        }
        catch (ClassCastException e) {
            EBLogger.error("Wizard data NBT tag was not of expected type!", e);
        }
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        class_2499 spellsDiscoveredTag = new class_2499();
        this.spellsDiscovered.forEach(spell -> spellsDiscoveredTag.add((Object)class_2519.method_23256((String)spell.getLocation().toString())));
        tag.method_10566("spellsDiscovered", (class_2520)spellsDiscoveredTag);
        storedVariables.forEach(k -> k.write(tag, this.spellData.get(k)));
    }
}

