/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.cca.player;

import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.cca.EBComponents;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.google.common.collect.EvictingQueue;
import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class WizardDataHolder
implements WizardData,
ComponentV3,
AutoSyncedComponent {
    public final Set<UUID> allies = new HashSet<UUID>();
    private final class_1657 provider;
    public Set<String> allyNames = new HashSet<String>();
    public SpellModifiers itemModifiers = new SpellModifiers();
    private SpellTier maxTierReached = SpellTiers.NOVICE;
    private Queue<AbstractMap.SimpleEntry<Spell, Long>> recentSpells = EvictingQueue.create((int)5);
    private Random random = new Random();

    public WizardDataHolder(class_1657 provider) {
        this.provider = provider;
    }

    private void sync() {
        EBComponents.WIZARD_DATA.sync((Object)this.provider);
    }

    @Override
    public void setTierReached(SpellTier tier) {
        if (!this.hasReachedTier(tier)) {
            this.maxTierReached = tier;
        }
        this.sync();
    }

    @Override
    public boolean hasReachedTier(SpellTier tier) {
        return tier.level >= this.maxTierReached.level;
    }

    @Override
    public boolean toggleAlly(class_1657 friend) {
        if (this.isPlayerAlly(friend)) {
            this.allies.remove(friend.method_5667());
            this.allyNames.remove(friend.method_5476().getString());
            this.sync();
            return false;
        }
        this.allies.add(friend.method_5667());
        this.allyNames.add(friend.method_5476().getString());
        this.sync();
        return true;
    }

    @Override
    public boolean isPlayerAlly(class_1657 ally) {
        return this.allies.contains(ally.method_5667()) || this.provider != null && this.provider.method_5781() != null && this.provider.method_5781().method_1204().contains(ally.method_5476().getString());
    }

    @Override
    public boolean isPlayerAlly(UUID playerUUID) {
        if (this.allies.contains(playerUUID)) {
            return true;
        }
        if (this.provider == null || this.provider.method_5781() == null) {
            return false;
        }
        return this.provider.method_5781().method_1204().stream().anyMatch(this.allyNames::contains);
    }

    @Override
    public SpellModifiers getSpellModifiers() {
        return this.itemModifiers;
    }

    @Override
    public void setSpellModifiers(SpellModifiers modifiers) {
        this.itemModifiers = modifiers;
        this.sync();
    }

    @Override
    public void trackRecentSpell(Spell spell, long timestamp) {
        this.recentSpells.add(new AbstractMap.SimpleEntry<Spell, Long>(spell, timestamp));
        this.sync();
    }

    @Override
    public int countRecentCasts(Spell spell) {
        return (int)this.recentSpells.stream().filter(entry -> ((Spell)entry.getKey()).equals(spell)).count();
    }

    @Override
    public void removeRecentCasts(Predicate<AbstractMap.SimpleEntry<Spell, Long>> predicate) {
        this.recentSpells.removeIf(predicate);
        this.sync();
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        SpellTier tier;
        class_2960 tierLocation = class_2960.method_12829((String)tag.method_10558("maxTier"));
        if (tierLocation != null && (tier = Services.REGISTRY_UTIL.getTier(tierLocation)) != null) {
            this.maxTierReached = tier;
        }
        class_2499 alliesTag = tag.method_10554("alliesUUID", 8);
        this.allies.clear();
        for (int i = 0; i < alliesTag.size(); ++i) {
            String uuidString = alliesTag.method_10608(i);
            try {
                UUID uuid = UUID.fromString(uuidString);
                this.allies.add(uuid);
                continue;
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
        }
        class_2499 allyNamesTag = tag.method_10554("allyNames", 8);
        this.allyNames.clear();
        for (int i = 0; i < allyNamesTag.size(); ++i) {
            String name = allyNamesTag.method_10608(i);
            this.allyNames.add(name);
        }
        if (tag.method_10545("itemModifiers")) {
            this.itemModifiers = SpellModifiers.fromTag(tag.method_10562("itemModifiers"));
        }
        class_2499 recentSpellsTag = tag.method_10554("recentSpells", 10);
        this.recentSpells.clear();
        for (int i = 0; i < recentSpellsTag.size(); ++i) {
            Spell spell;
            class_2487 spellEntryTag = recentSpellsTag.method_10602(i);
            class_2960 spellLocation = class_2960.method_12829((String)spellEntryTag.method_10558("spell"));
            long timestamp = spellEntryTag.method_10537("timestamp");
            if (spellLocation == null || (spell = Services.REGISTRY_UTIL.getSpell(spellLocation)) == null) continue;
            this.recentSpells.add(new AbstractMap.SimpleEntry<Spell, Long>(spell, timestamp));
        }
        if (tag.method_10545("randomSeed")) {
            long seed = tag.method_10537("randomSeed");
            this.random = new Random(seed);
        }
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        tag.method_10582("maxTier", this.maxTierReached.getOrCreateLocation().toString());
        class_2499 alliesTag = new class_2499();
        this.allies.forEach(uuid -> alliesTag.add((Object)class_2519.method_23256((String)uuid.toString())));
        tag.method_10566("alliesUUID", (class_2520)alliesTag);
        class_2499 allyNamesTag = new class_2499();
        this.allyNames.forEach(name -> allyNamesTag.add((Object)class_2519.method_23256((String)name)));
        tag.method_10566("allyNames", (class_2520)allyNamesTag);
        tag.method_10566("itemModifiers", (class_2520)this.itemModifiers.toTag());
        class_2499 recentSpellsTag = new class_2499();
        for (AbstractMap.SimpleEntry simpleEntry : this.recentSpells) {
            class_2487 spellEntryTag = new class_2487();
            spellEntryTag.method_10582("spell", ((Spell)simpleEntry.getKey()).getLocation().toString());
            spellEntryTag.method_10544("timestamp", ((Long)simpleEntry.getValue()).longValue());
            recentSpellsTag.add((Object)spellEntryTag);
        }
        tag.method_10566("recentSpells", (class_2520)recentSpellsTag);
        long seed = this.random.nextLong();
        tag.method_10544("randomSeed", seed);
    }
}

