/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.util.GlyphClientHandler;
import com.binaris.wizardry.api.content.event.EBLivingTick;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.client.SpellHUDSkin;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5498;
import net.minecraft.class_746;

public final class SpellGUIDisplay {
    public static final int CHARGE_METER_WIDTH = 25;
    public static final int CHARGE_METER_HEIGHT = 9;
    public static final int SPELL_ICON_SIZE = 32;
    public static final float SPELL_NAME_SCALE = 0.5f;
    public static final float SPELL_NAME_OPACITY = 0.3f;
    private static final class_2960 CHARGE_METER = WizardryMainMod.location("textures/gui/spell_charge_meter.png");
    private static final Map<String, SpellHUDSkin> SKINS = new LinkedHashMap<String, SpellHUDSkin>(14);
    private static final int SPELL_SWITCH_TIME = 4;
    private static final class_310 mc = class_310.method_1551();
    private static int switchTimer = 0;

    public static void init() {
        SpellGUIDisplay.addSkin("default", WizardryMainMod.location("gui/spell_hud/default.png"), WizardryMainMod.location("gui/spell_hud/default.json"));
    }

    public static void addSkin(String key, class_2960 texture, class_2960 metadata) {
        EBLogger.debug("Loading spell HUD skin: " + key, new Object[0]);
        SKINS.put(key, new SpellHUDSkin(texture, metadata));
    }

    @Nullable
    public static SpellHUDSkin getSkin(String key) {
        SpellHUDSkin skin = SKINS.get(key);
        if (skin == null) {
            EBLogger.info("The spell HUD skin specified in the config did not match any of the loaded skins; using the default skin as a fallback.", new Object[0]);
            skin = SKINS.get("default");
            if (skin == null) {
                EBLogger.warn("The default spell HUD skin is missing! A resource pack must have overridden it with an invalid JSON file (default.json), please try again without any resource packs.", new Object[0]);
                return null;
            }
        }
        return skin;
    }

    public static void draw(class_332 guiGraphics, class_4587 stack, float partialTicks) {
        ISpellCastingItem castingItem;
        if (!EBConfig.showSpellHUD && !EBConfig.showChargeMeter) {
            return;
        }
        class_746 player = SpellGUIDisplay.mc.field_1724;
        if (player.method_7325()) {
            return;
        }
        class_1799 wand = player.method_6047();
        boolean mainHand = true;
        class_1792 class_17922 = wand.method_7909();
        if (!(class_17922 instanceof ISpellCastingItem) || !(castingItem = (ISpellCastingItem)class_17922).showSpellHUD((class_1657)player, wand)) {
            ISpellCastingItem castingItem2;
            wand = player.method_6079();
            mainHand = false;
            class_1792 class_17923 = wand.method_7909();
            if (!(class_17923 instanceof ISpellCastingItem) || !(castingItem2 = (ISpellCastingItem)class_17923).showSpellHUD((class_1657)player, wand)) {
                return;
            }
        }
        int width = mc.method_22683().method_4486();
        int height = mc.method_22683().method_4502();
        SpellGUIDisplay.renderChargeMeter(stack, (class_1657)player, wand, width, height, partialTicks);
        SpellGUIDisplay.renderSpellHUD(guiGraphics, stack, (class_1657)player, wand, mainHand, width, height, partialTicks, true);
        SpellGUIDisplay.renderSpellHUD(guiGraphics, stack, (class_1657)player, wand, mainHand, width, height, partialTicks, false);
    }

    public static void playSpellSwitchAnimation(boolean next) {
        switchTimer = next ? 4 : -4;
    }

    public static void renderSpellHUD(class_332 guiGraphics, class_4587 stack, class_1657 player, class_1799 wand, boolean mainHand, int width, int height, float partialTicks, boolean textLayer) {
        SpellHUDSkin skin;
        if (!EBConfig.showSpellHUD) {
            return;
        }
        if (!(wand.method_7909() instanceof ISpellCastingItem)) {
            throw new IllegalArgumentException("The given stack must contain an ISpellCastingItem!");
        }
        boolean flipX = EBConfig.spellHUDFlipX;
        boolean flipY = EBConfig.spellHUDFlipY;
        if (EBConfig.spellHUDDynamicPositioning) {
            boolean bl = flipX = flipX == ((mainHand ? player.method_6068() : player.method_6068().method_5928()) == class_1306.field_6182);
        }
        if ((skin = SpellGUIDisplay.getSkin("default")) == null) {
            return;
        }
        stack.method_22903();
        int x = flipX ? width : 0;
        int y = flipY ? 0 : height;
        Spell spell = ((ISpellCastingItem)wand.method_7909()).getCurrentSpell(wand);
        int cooldown = ((ISpellCastingItem)wand.method_7909()).getCurrentCooldown(wand, player.method_37908());
        int maxCooldown = ((ISpellCastingItem)wand.method_7909()).getCurrentMaxCooldown(wand);
        if (textLayer) {
            float animationProgress = Math.signum(switchTimer) * (((float)(4 - Math.abs(switchTimer)) + partialTicks) / 4.0f);
            class_2561 prevSpellName = SpellGUIDisplay.getFormattedSpellName(((ISpellCastingItem)wand.method_7909()).getPreviousSpell(wand), player, 0);
            class_2561 spellName = SpellGUIDisplay.getFormattedSpellName(((ISpellCastingItem)wand.method_7909()).getCurrentSpell(wand), player, cooldown);
            class_2561 nextSpellName = SpellGUIDisplay.getFormattedSpellName(((ISpellCastingItem)wand.method_7909()).getNextSpell(wand), player, 0);
            skin.drawText(guiGraphics, x, y, flipX, flipY, prevSpellName, spellName, nextSpellName, animationProgress);
        } else {
            boolean discovered = true;
            if (!player.method_7337()) {
                discovered = Services.OBJECT_DATA.getSpellManagerData(player).hasSpellBeenDiscovered(spell);
            }
            class_2960 icon = discovered ? WizardryMainMod.location("textures/spells/%s.png".formatted(spell.getLocation().method_12832())) : WizardryMainMod.location("textures/spells/none.png");
            float progress = 1.0f;
            if (!player.method_7337()) {
                progress = maxCooldown == 0 ? 1.0f : ((float)maxCooldown - (float)cooldown + partialTicks) / (float)maxCooldown;
            }
            skin.drawBackground(stack, x, y, flipX, flipY, icon, progress, player.method_7337(), player.method_6059(EBMobEffects.ARCANE_JAMMER.get()));
        }
        stack.method_22909();
    }

    public static void renderChargeMeter(class_4587 stack, class_1657 player, class_1799 wand, int width, int height, float partialTicks) {
        if (player.method_7325()) {
            return;
        }
        stack.method_22903();
        if (!EBConfig.showChargeMeter) {
            return;
        }
        if (SpellGUIDisplay.mc.field_1690.field_1866) {
            return;
        }
        if (SpellGUIDisplay.mc.field_1690.method_31044() != class_5498.field_26664) {
            return;
        }
        if (wand != player.method_6030()) {
            return;
        }
        if (!(wand.method_7909() instanceof ISpellCastingItem)) {
            throw new IllegalArgumentException("The given stack must contain an ISpellCastingItem!");
        }
        Spell spell = ((ISpellCastingItem)wand.method_7909()).getCurrentSpell(wand);
        int chargeup = spell.getCharge();
        if ((chargeup = (int)((float)chargeup * Services.OBJECT_DATA.getWizardData(player).getSpellModifiers().get("chargeup"))) <= 0) {
            return;
        }
        if (player.method_6048() == 0) {
            return;
        }
        float charge = ((float)player.method_6048() + partialTicks) / (float)chargeup;
        if (charge > 1.0f) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)CHARGE_METER);
        int x1 = width / 2 - 12 - 1;
        float y = (float)height / 2.0f - 4.5f - 0.5f;
        int w = (int)(12.5f * charge);
        int u = 25 - w;
        DrawingUtils.drawTexturedRect(x1, y, 0, 0, w, 9, 32, 32);
        DrawingUtils.drawTexturedRect(x1 + u, y, u, 0, w, 9, 32, 32);
        stack.method_22909();
    }

    private static class_2561 getFormattedSpellName(Spell spell, class_1657 player, int cooldown) {
        class_2583 format;
        boolean discovered = true;
        if (!player.method_7337()) {
            discovered = Services.OBJECT_DATA.getSpellManagerData(player).hasSpellBeenDiscovered(spell);
        }
        class_2583 class_25832 = format = cooldown > 0 ? class_2583.field_24360.method_10977(class_124.field_1080) : class_2583.field_24360.method_10977(spell.getElement().getColor());
        if (!discovered) {
            format = class_2583.field_24360.method_10977(class_124.field_1078).method_27704(new class_2960("minecraft", "alt"));
        }
        if (player.method_6059(EBMobEffects.ARCANE_JAMMER.get())) {
            format = class_2583.field_24360.method_36141(Boolean.valueOf(true));
        }
        class_5250 name = discovered ? class_2561.method_43471((String)spell.getDescriptionId()) : class_2561.method_43470((String)SpellGlyphData.getGlyphName(spell, GlyphClientHandler.INSTANCE.getGlyphData()));
        name.method_27696(format);
        return name;
    }

    public static void onLivingTickEvent(EBLivingTick event) {
        if (event.getLevel().field_9236 && event.getEntity() == SpellGUIDisplay.mc.field_1724) {
            if (switchTimer > 0) {
                --switchTimer;
            } else if (switchTimer < 0) {
                ++switchTimer;
            }
        }
    }
}

