/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.effect;

import com.binaris.wizardry.api.content.data.ArcaneLockData;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.core.platform.Services;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2818;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public final class ArcaneLockRender {
    private static final class_2960[] TEXTURES = new class_2960[8];
    private static final int RENDER_DISTANCE_CHUNKS = 8;
    private static final int MAX_RENDER_DISTANCE_SQ = 4096;

    private ArcaneLockRender() {
    }

    public static void render(class_4184 camera, class_4587 poseStack, float partialTicks) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_243 origin = player.method_5836(partialTicks);
        class_243 cameraPos = camera.method_19326();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        boolean renderStarted = false;
        class_1923 playerChunkPos = new class_1923(class_2338.method_49638((class_2374)origin));
        for (int chunkX = playerChunkPos.field_9181 - 8; chunkX <= playerChunkPos.field_9181 + 8; ++chunkX) {
            for (int chunkZ = playerChunkPos.field_9180 - 8; chunkZ <= playerChunkPos.field_9180 + 8; ++chunkZ) {
                if (!world.method_8393(chunkX, chunkZ)) continue;
                class_2818 chunk = world.method_8497(chunkX, chunkZ);
                for (class_2586 blockEntity : chunk.method_12214().values()) {
                    ArcaneLockData data;
                    if (!(blockEntity instanceof class_2624)) continue;
                    class_2624 containerBlock = (class_2624)blockEntity;
                    class_2338 pos = blockEntity.method_11016();
                    double distSq = pos.method_10268(origin.field_1352, origin.field_1351, origin.field_1350);
                    if (distSq > 4096.0 || (data = Services.OBJECT_DATA.getArcaneLockData((class_2586)containerBlock)) == null || !data.isArcaneLocked()) continue;
                    if (!renderStarted) {
                        renderStarted = true;
                        poseStack.method_22903();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.disableCull();
                        RenderSystem.depthMask((boolean)false);
                        RenderSystem.setShader(class_757::method_34542);
                        int textureIndex = player.field_6012 % (TEXTURES.length * 2) / 2;
                        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURES[textureIndex]);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
                        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
                    }
                    class_238 boundingBox = world.method_8320(pos).method_26218((class_1922)world, pos).method_1107().method_1014(0.05).method_996(pos);
                    class_243[] vertices = GeometryUtil.getVertices(boundingBox);
                    Matrix4f matrix = poseStack.method_23760().method_23761();
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[0], vertices[1], vertices[3], vertices[2], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[6], vertices[7], vertices[2], vertices[3], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[5], vertices[6], vertices[1], vertices[2], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[4], vertices[5], vertices[0], vertices[1], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[7], vertices[4], vertices[3], vertices[0], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[5], vertices[4], vertices[6], vertices[7], 0.0f, 0.0f, 1.0f, 1.0f);
                }
            }
        }
        if (renderStarted) {
            class_286.method_43433((class_287.class_7433)buffer.method_1326());
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.method_22909();
        }
    }

    private static void drawFace(class_287 buffer, Matrix4f matrix, class_243 topLeft, class_243 topRight, class_243 bottomLeft, class_243 bottomRight, float u1, float v1, float u2, float v2) {
        buffer.method_22918(matrix, (float)topLeft.field_1352, (float)topLeft.field_1351, (float)topLeft.field_1350).method_22913(u1, v1).method_1344();
        buffer.method_22918(matrix, (float)topRight.field_1352, (float)topRight.field_1351, (float)topRight.field_1350).method_22913(u2, v1).method_1344();
        buffer.method_22918(matrix, (float)bottomRight.field_1352, (float)bottomRight.field_1351, (float)bottomRight.field_1350).method_22913(u2, v2).method_1344();
        buffer.method_22918(matrix, (float)bottomLeft.field_1352, (float)bottomLeft.field_1351, (float)bottomLeft.field_1350).method_22913(u1, v2).method_1344();
    }

    static {
        for (int i = 0; i < TEXTURES.length; ++i) {
            ArcaneLockRender.TEXTURES[i] = new class_2960("ebwizardry", "textures/block/arcane_lock_" + i + ".png");
        }
    }
}

