/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.elements;

import net.minecraft.class_1799;
import net.minecraft.class_332;

public abstract class TooltipElement {
    public final int spaceAfter;
    private final TooltipElement[] children;

    public TooltipElement(int spaceAfter, TooltipElement ... children) {
        this.children = children;
        this.spaceAfter = spaceAfter;
    }

    public int getTotalHeight(class_1799 stack) {
        if (!this.isVisible(stack)) {
            return 0;
        }
        int height = this.getHeight(stack);
        for (TooltipElement child : this.children) {
            height += child.getTotalHeight(stack);
        }
        return height + this.spaceAfter;
    }

    public int drawBackgroundLayer(class_332 guiGraphics, int x, int y, class_1799 stack, float partialTicks, int mouseX, int mouseY) {
        if (!this.isVisible(stack)) {
            return y;
        }
        this.drawBackground(guiGraphics, x, y, stack, partialTicks, mouseX, mouseY);
        y += this.getHeight(stack);
        for (TooltipElement child : this.children) {
            y = child.drawBackgroundLayer(guiGraphics, x, y, stack, partialTicks, mouseX, mouseY);
        }
        return y + this.spaceAfter;
    }

    public int drawForegroundLayer(class_332 guiGraphics, int x, int y, class_1799 stack, int mouseX, int mouseY) {
        if (!this.isVisible(stack)) {
            return y;
        }
        this.drawForeground(guiGraphics, x, y, stack, mouseX, mouseY);
        y += this.getHeight(stack);
        for (TooltipElement child : this.children) {
            y = child.drawForegroundLayer(guiGraphics, x, y, stack, mouseX, mouseY);
        }
        return y + this.spaceAfter;
    }

    protected abstract boolean isVisible(class_1799 var1);

    protected abstract int getHeight(class_1799 var1);

    protected abstract void drawBackground(class_332 var1, int var2, int var3, class_1799 var4, float var5, int var6, int var7);

    protected abstract void drawForeground(class_332 var1, int var2, int var3, class_1799 var4, int var5, int var6);
}

