/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.elements;

import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.client.gui.elements.TooltipElement;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.setup.registries.SpellTiers;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class TooltipElementProgressionBar
extends TooltipElement {
    private final int height;

    public TooltipElementProgressionBar(int height, int spaceAfter) {
        super(spaceAfter, new TooltipElement[0]);
        this.height = height;
    }

    @Override
    protected boolean isVisible(class_1799 stack) {
        return stack.method_7909() instanceof WandItem;
    }

    @Override
    protected int getHeight(class_1799 stack) {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return 9 + 1 + 3;
    }

    @Override
    protected void drawBackground(class_332 guiGraphics, int x, int y, class_1799 stack, float partialTicks, int mouseX, int mouseY) {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        y += 9 + 1;
        float progressFraction = 1.0f;
        SpellTier nextTier = this.getNextTier(stack);
        if (nextTier != null) {
            progressFraction = (float)WandHelper.getProgression(stack) / (float)nextTier.getProgression();
        }
        DrawingUtils.drawTexturedRect(x, y, 176, this.height + 3, 131, 3, 512, 512);
        int width = (int)(131.0f * progressFraction);
        DrawingUtils.drawTexturedRect(x, y, 176, this.height, width, 3, 512, 512);
    }

    @Override
    protected void drawForeground(class_332 guiGraphics, int x, int y, class_1799 stack, int mouseX, int mouseY) {
        SpellTier tier = ((WandItem)stack.method_7909()).getTier(stack);
        guiGraphics.method_51433(class_310.method_1551().field_1772, tier.getDescriptionFormatted().getString(), x, y, tier.getDescriptionFormatted().method_10866().method_10973().method_27716(), true);
        SpellTier nextTier = this.getNextTier(stack);
        if (nextTier != null) {
            class_5250 s = nextTier.getDescriptionFormatted().method_27661().method_27692(class_124.field_1063);
            if (WandHelper.getProgression(stack) >= nextTier.getProgression()) {
                s = nextTier.getDescriptionFormatted();
            }
            guiGraphics.method_51433(class_310.method_1551().field_1772, s.getString(), x + 144 - 12 - class_310.method_1551().field_1772.method_1727(s.getString()), y, s.method_10866().method_10973().method_27716(), true);
        }
    }

    @Nullable
    private SpellTier getNextTier(class_1799 stack) {
        SpellTier tier = ((WandItem)stack.method_7909()).getTier(stack);
        if (tier != SpellTiers.MASTER) {
            return SpellTiers.getNextByLevel(tier.level + 1);
        }
        return null;
    }
}

