/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.screens;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.client.EBClientConstants;
import com.binaris.wizardry.client.gui.button.GuiButtonApply;
import com.binaris.wizardry.client.gui.button.GuiButtonClear;
import com.binaris.wizardry.client.gui.elements.TooltipElement;
import com.binaris.wizardry.client.gui.elements.TooltipElementProgressionBar;
import com.binaris.wizardry.client.gui.elements.TooltipElementSpellEntry;
import com.binaris.wizardry.client.gui.elements.TooltipElementSpellList;
import com.binaris.wizardry.client.gui.elements.TooltipElementText;
import com.binaris.wizardry.client.gui.elements.TooltipElementUpgradeList;
import com.binaris.wizardry.content.menu.ArcaneWorkbenchMenu;
import com.binaris.wizardry.core.networking.c2s.ControlInputPacketC2S;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_465;
import org.jetbrains.annotations.NotNull;

public class ArcaneWorkbenchScreen
extends class_465<ArcaneWorkbenchMenu> {
    private final class_1661 playerInventory;
    private final ArcaneWorkbenchMenu menu;
    private final List<TooltipElement> tooltipElements = new ArrayList<TooltipElement>();
    private class_339 applyBtn;
    private class_339 clearBtn;
    private int animationTimer = 0;

    public ArcaneWorkbenchScreen(ArcaneWorkbenchMenu menu, class_1661 playerInventory, class_2561 name) {
        super((class_1703)menu, playerInventory, name);
        this.menu = menu;
        this.playerInventory = playerInventory;
        this.field_2792 = 176;
        this.field_2779 = 220;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.field_22787 == null) {
            return;
        }
        if (this.field_22787.field_1724 == null) {
            return;
        }
        this.field_22787.field_1724.field_7512 = this.menu;
        this.field_2776 = (this.field_22789 - 176) / 2;
        this.field_2800 = (this.field_22790 - this.field_2779) / 2;
        this.method_37067();
        this.applyBtn = new GuiButtonApply(0, this.field_22789 / 2 + 64, this.field_22790 / 2 + 3, button -> {
            if (button.field_22763) {
                ControlInputPacketC2S packet = new ControlInputPacketC2S(ControlInputPacketC2S.ControlType.APPLY_BUTTON);
                Services.NETWORK_HELPER.sendToServer(packet);
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)EBSounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND.get(), (float)1.0f));
                this.animationTimer = 20;
            }
        });
        this.method_37063((class_364)this.applyBtn);
        this.clearBtn = new GuiButtonClear(0, this.field_22789 / 2 + 64, this.field_22790 / 2 - 16, button -> {
            if (button.field_22763) {
                ControlInputPacketC2S packet = new ControlInputPacketC2S(ControlInputPacketC2S.ControlType.CLEAR_BUTTON);
                Services.NETWORK_HELPER.sendToServer(packet);
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)EBSounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND.get(), (float)0.8f));
                this.animationTimer = 20;
            }
        });
        this.method_37063((class_364)this.clearBtn);
        this.tooltipElements.clear();
        this.tooltipElements.add(new TooltipElementText.TooltipElementItemName(class_2583.field_24360.method_10977(class_124.field_1068), 5));
        this.tooltipElements.add(new TooltipElementText.TooltipElementManaReadout(5));
        this.tooltipElements.add(new TooltipElementProgressionBar(this.field_2779, 5));
        this.tooltipElements.add(new TooltipElementSpellList(5, this.generateSpellEntries()));
        this.tooltipElements.add(new TooltipElementUpgradeList(this, 5));
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_1735 centreSlot = this.menu.method_7611(9);
        this.field_2792 = 176;
        this.field_2776 = (this.field_22789 - 176) / 2;
        if (centreSlot.method_7681() && centreSlot.method_7677().method_7909() instanceof IWorkbenchItem && ((IWorkbenchItem)centreSlot.method_7677().method_7909()).showTooltip(centreSlot.method_7677())) {
            this.field_2792 += 144;
        }
        this.applyBtn.field_22763 = centreSlot.method_7681();
        this.clearBtn.field_22763 = centreSlot.method_7681() && centreSlot.method_7677().method_7909() instanceof IWorkbenchItem && ((IWorkbenchItem)centreSlot.method_7677().method_7909()).isClearable();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(@NotNull class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)EBClientConstants.ARCANE_WORKBENCH_CONTAINER_TEXTURE);
        int left = this.field_2776;
        int top = this.field_2800;
        DrawingUtils.drawTexturedRect(left + 38, top + 22, 320, 0, 100, 100, 512, 512);
        if (this.animationTimer > 0) {
            guiGraphics.method_51448().method_22903();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            int x = left + 38 + 50;
            int y = top + 22 + 50;
            float scale = ((float)this.animationTimer + partialTick) / 20.0f;
            scale = (float)(1.0 - Math.pow(1.0f - scale, 1.4f));
            guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
            guiGraphics.method_51448().method_46416((float)x / scale, (float)y / scale, 0.0f);
            DrawingUtils.drawTexturedRectF(guiGraphics.method_51448(), -78.0f, -78.0f, 320.0f, 100.0f, 156.0f, 156.0f, 512.0f, 512.0f);
            RenderSystem.disableBlend();
            guiGraphics.method_51448().method_22909();
        }
        DrawingUtils.drawTexturedRect(left, top, 0, 0, 176, this.field_2779, 512, 512);
        float opacity = ((float)this.animationTimer + partialTick) / 20.0f;
        for (int i = 0; i < 8; ++i) {
            class_1735 slot = this.menu.method_7611(i);
            if (slot.field_7873 < 0 || slot.field_7872 < 0) continue;
            DrawingUtils.drawTexturedRect(this.field_2776 + slot.field_7873 - 10, this.field_2800 + slot.field_7872 - 10, 0, 220, 36, 36, 512, 512);
            if (this.animationTimer <= 0 || !slot.method_7681()) continue;
            guiGraphics.method_51448().method_22903();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            DrawingUtils.drawTexturedRect(this.field_2776 + slot.field_7873 - 10, this.field_2800 + slot.field_7872 - 10, 36, 220, 36, 36, 512, 512);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            guiGraphics.method_51448().method_22909();
        }
        if (this.animationTimer > 0) {
            class_1735 crystals = this.menu.method_7611(8);
            class_1735 upgrades = this.menu.method_7611(10);
            if (crystals.method_7681()) {
                guiGraphics.method_51448().method_22903();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                DrawingUtils.drawTexturedRect(this.field_2776 + crystals.field_7873 - 8, this.field_2800 + crystals.field_7872 - 8, 420, 0, 32, 32, 512, 512);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.method_51448().method_22909();
            }
            if (upgrades.method_7681()) {
                guiGraphics.method_51448().method_22903();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                DrawingUtils.drawTexturedRect(this.field_2776 + upgrades.field_7873 - 8, this.field_2800 + upgrades.field_7872 - 8, 420, 0, 32, 32, 512, 512);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.method_51448().method_22909();
            }
        }
        if (this.menu.method_7611(9).method_7681()) {
            class_1799 stack = this.menu.method_7611(9).method_7677();
            if (!(stack.method_7909() instanceof IWorkbenchItem)) {
                EBLogger.warn("Invalid item in central slot of arcane workbench, how did that get there?!", new Object[0]);
                return;
            }
            if (((IWorkbenchItem)stack.method_7909()).showTooltip(stack)) {
                int tooltipHeight = this.tooltipElements.stream().mapToInt(e -> e.getTotalHeight(stack)).sum() - this.tooltipElements.get((int)(this.tooltipElements.size() - 1)).spaceAfter;
                DrawingUtils.drawTexturedRect(left + 176, top, 176, 0, 144, 6 + tooltipHeight, 512, 512);
                DrawingUtils.drawTexturedRect(left + 176, top + 6 + tooltipHeight, 176, this.field_2779 - 6, 144, 6, 512, 512);
                int x = left + 176 + 6;
                int y = top + 6;
                for (TooltipElement element : this.tooltipElements) {
                    y = element.drawBackgroundLayer(guiGraphics, x, y, stack, partialTick, mouseX, mouseY);
                }
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)EBClientConstants.ARCANE_WORKBENCH_CONTAINER_TEXTURE);
        RenderSystem.disableBlend();
    }

    protected void method_2388(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = 0;
        guiGraphics.method_51439(this.field_22793, this.method_25440(), left + 8, 6, 0x404040, false);
        guiGraphics.method_51433(this.field_22793, this.playerInventory.method_5477().getString(), left + 8, this.field_2779 - 96 + 2, 0x404040, false);
        if (this.menu.method_7611(9).method_7681()) {
            class_1799 stack = this.menu.method_7611(9).method_7677();
            if (!(stack.method_7909() instanceof IWorkbenchItem)) {
                EBLogger.warn("Invalid item in central slot of arcane workbench, how did that get there?!", new Object[0]);
                return;
            }
            if (((IWorkbenchItem)stack.method_7909()).showTooltip(stack)) {
                int x = left + 176 + 6;
                int y = 6;
                for (TooltipElement element : this.tooltipElements) {
                    y = element.drawForegroundLayer(guiGraphics, x, y, stack, mouseX, mouseY);
                }
            }
        }
    }

    protected void method_37432() {
        if (this.animationTimer > 0) {
            --this.animationTimer;
        }
        if (this.menu.needsRefresh) {
            this.menu.needsRefresh = false;
        }
    }

    private TooltipElement[] generateSpellEntries() {
        TooltipElement[] entries = new TooltipElement[8];
        for (int i = 0; i < 8; ++i) {
            entries[i] = new TooltipElementSpellEntry(this, i);
        }
        return entries;
    }

    @NotNull
    public ArcaneWorkbenchMenu getMenu() {
        return this.menu;
    }
}

