/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.screens.abstr;

import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.client.util.GlyphClientHandler;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public abstract class SpellInfoScreen
extends class_437 {
    protected static final String TRANSLATION_KEY_PREFIX = "gui.ebwizardry.spell_book";
    protected final int xSize;
    protected final int ySize;
    protected int textureWidth = 512;
    protected int textureHeight = 256;

    protected SpellInfoScreen(int xSize, int ySize, class_2561 component) {
        super(component);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    protected void setTextureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
    }

    public abstract Spell getSpell();

    public abstract class_2960 getTexture();

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int left = this.field_22789 / 2 - this.xSize / 2;
        int top = this.field_22790 / 2 - this.ySize / 2;
        this.method_25420(guiGraphics);
        this.drawBackgroundLayer(left, top, mouseX, mouseY);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.drawForegroundLayer(guiGraphics, left, top, mouseX, mouseY);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void drawBackgroundLayer(int left, int top, int mouseX, int mouseY) {
        boolean discovered = ClientUtils.shouldDisplayDiscovered(this.getSpell(), null);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)(discovered ? this.getSpell().getIcon() : Spells.NONE.getIcon()));
        DrawingUtils.drawTexturedRect(left + 146, top + 20, 0, 0, 128, 128, 128, 128);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getTexture());
        DrawingUtils.drawTexturedRect(left, top, 0, 0, this.xSize, this.ySize, this.textureWidth, this.textureHeight);
    }

    protected void drawForegroundLayer(class_332 guiGraphics, int left, int top, int mouseX, int mouseY) {
        boolean discovered = ClientUtils.shouldDisplayDiscovered(this.getSpell(), null);
        class_327 font = discovered ? this.field_22787.field_1772 : this.field_22787.field_39924;
        class_5250 spellName = discovered ? ((class_5250)this.getSpell().getDescriptionFormatted()).method_27692(class_124.field_1074) : class_2561.method_43470((String)SpellGlyphData.getGlyphName(this.getSpell(), GlyphClientHandler.INSTANCE.getGlyphData())).method_27696(class_2583.field_24360.method_27704(new class_2960("minecraft", "alt")));
        guiGraphics.method_51439(font, (class_2561)spellName, left + 17, top + 15, 0, false);
        guiGraphics.method_51439(font, (class_2561)class_2561.method_43471((String)this.getSpell().getType().getDisplayName()), left + 17, top + 26, 0x777777, false);
        class_124 tierColor = this.getSpell().getTier() == SpellTiers.NOVICE ? class_124.field_1080 : this.getSpell().getTier().getColor();
        class_5250 tier = class_2561.method_43469((String)"gui.ebwizardry.spell_book.tier", (Object[])new Object[]{((class_5250)this.getSpell().getTier().getDescriptionFormatted()).method_27692(tierColor)});
        guiGraphics.method_51439(this.field_22793, (class_2561)tier, left + 17, top + 45, 0, false);
        class_124 elementColor = this.getSpell().getElement() == Elements.HEALING ? class_124.field_1065 : this.getSpell().getElement().getColor();
        class_5250 element = class_2561.method_43469((String)"gui.ebwizardry.spell_book.element", (Object[])new Object[]{((class_5250)this.getSpell().getElement().getDescriptionFormatted()).method_27692(elementColor)});
        if (!discovered) {
            element = class_2561.method_43471((String)"gui.ebwizardry.spell_book.element_undiscovered");
        }
        guiGraphics.method_51439(this.field_22793, (class_2561)element, left + 17, top + 57, 0, false);
        String manaCost = class_1074.method_4662((String)"gui.ebwizardry.spell_book.mana_cost", (Object[])new Object[]{this.getSpell().getCost()});
        if (!this.getSpell().isInstantCast()) {
            manaCost = class_1074.method_4662((String)"gui.ebwizardry.spell_book.mana_cost_continuous", (Object[])new Object[]{this.getSpell().getCost()});
        }
        if (!discovered) {
            manaCost = class_1074.method_4662((String)"gui.ebwizardry.spell_book.mana_cost_undiscovered", (Object[])new Object[0]);
        }
        guiGraphics.method_51433(this.field_22793, manaCost, left + 17, top + 69, 0, false);
        class_5250 spellDesc = discovered ? ((class_5250)this.getSpell().getDesc()).method_27692(class_124.field_1074) : class_2561.method_43470((String)SpellGlyphData.getGlyphDescription(this.getSpell(), GlyphClientHandler.INSTANCE.getGlyphData())).method_27696(class_2583.field_24360.method_27704(new class_2960("minecraft", "alt")));
        guiGraphics.method_51440(font, (class_5348)spellDesc, left + 17, top + 83, 118, 0);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)EBSounds.MISC_BOOK_OPEN.get(), (float)1.0f));
    }
}

