/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.particle;

import com.binaris.wizardry.api.client.particle.ParticleTargeted;
import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleLightning
extends ParticleTargeted {
    private static final float THICKNESS = 0.04f;
    private static final float MAX_SEGMENT_LENGTH = 0.6f;
    private static final float MIN_SEGMENT_LENGTH = 0.2f;
    private static final float VERTEX_JITTER = 0.15f;
    private static final int MAX_FORK_SEGMENTS = 3;
    private static final float FORK_CHANCE = 0.3f;
    private static final int UPDATE_PERIOD = 1;

    public ParticleLightning(class_638 world, double x, double y, double z, class_4002 spriteProvider) {
        super(world, x, y, z, spriteProvider, false);
        this.seed = this.random.nextLong();
        this.method_3084(0.2f, 0.6f, 1.0f);
        this.method_3077(3);
        this.field_17867 = 2.4f;
    }

    @Override
    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    @Override
    protected boolean shouldApplyOriginOffset() {
        return false;
    }

    @Override
    protected void draw(class_4587 stack, class_289 tesselator, float length, float tickDelta) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        boolean freeEnd = this.target == null;
        int numberOfSegments = Math.round(length / 0.6f);
        for (int layer = 0; layer < 3; ++layer) {
            float px = 0.0f;
            float py = 0.0f;
            float pz = 0.0f;
            this.random.setSeed(this.seed + (long)(this.field_3866 / 1));
            for (int i = 0; i < numberOfSegments - 1; ++i) {
                float px2 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.field_17867;
                float py2 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.field_17867;
                float pz2 = pz + length / (float)numberOfSegments;
                this.drawSegment(stack, tesselator, layer, px, py, pz, px2, py2, pz2, 0.04f * this.field_17867);
                if (this.random.nextFloat() < 0.3f) {
                    float px3 = px;
                    float py3 = py;
                    float pz3 = pz;
                    for (int j = 0; j < this.random.nextInt(2) + 1; ++j) {
                        float px4 = px3 + (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.field_17867;
                        float py4 = py3 + (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.field_17867;
                        float pz4 = pz3 + 0.2f + this.random.nextFloat() * 0.40000004f;
                        this.drawSegment(stack, tesselator, layer, px3, py3, pz3, px4, py4, pz4, 0.032f * this.field_17867);
                        if (this.random.nextFloat() < 0.3f) {
                            float px5 = px3 + (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.field_17867;
                            float py5 = py3 + (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.field_17867;
                            float pz5 = pz3 + 0.2f + this.random.nextFloat() * 0.40000004f;
                            this.drawSegment(stack, tesselator, layer, px3, py3, pz3, px5, py5, pz5, 0.024f * this.field_17867);
                        }
                        px3 = px4;
                        py3 = py4;
                        pz3 = pz4;
                    }
                }
                px = px2;
                py = py2;
                pz = pz2;
            }
            float px2 = freeEnd ? (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.field_17867 : 0.0f;
            float py2 = freeEnd ? (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.field_17867 : 0.0f;
            this.drawSegment(stack, tesselator, layer, px, py, pz, px2, py2, length, 0.04f * this.field_17867);
        }
        RenderSystem.disableBlend();
    }

    private void drawSegment(class_4587 stack, class_289 tesselator, int layer, float x1, float y1, float z1, float x2, float y2, float z2, float thickness) {
        class_287 buffer = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        switch (layer) {
            case 0: {
                this.drawShearedBox(stack, buffer, x1, y1, z1, x2, y2, z2, 0.25f * thickness, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.drawShearedBox(stack, buffer, x1, y1, z1, x2, y2, z2, 0.6f * thickness, (this.field_3861 + 1.0f) / 2.0f, (this.field_3842 + 1.0f) / 2.0f, (this.field_3859 + 1.0f) / 2.0f, 0.65f);
                break;
            }
            case 2: {
                this.drawShearedBox(stack, buffer, x1, y1, z1, x2, y2, z2, thickness, this.field_3861, this.field_3842, this.field_3859, 0.3f);
            }
        }
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }

    private void drawShearedBox(class_4587 stack, class_287 buffer, float x1, float y1, float z1, float x2, float y2, float z2, float width, float r, float g, float b, float a) {
        buffer.method_22918(stack.method_23760().method_23761(), x1 - width, y1 - width, z1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x2 - width, y2 - width, z2).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x1 - width, y1 + width, z1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x2 - width, y2 + width, z2).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x1 + width, y1 + width, z1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x2 + width, y2 + width, z2).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x1 + width, y1 - width, z1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x2 + width, y2 - width, z2).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x1 - width, y1 - width, z1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(stack.method_23760().method_23761(), x2 - width, y2 - width, z2).method_22915(r, g, b, a).method_1344();
    }

    public static class LightningProvider
    implements class_707<class_2400> {
        static class_4002 spriteProvider;

        public LightningProvider(class_4002 sprite) {
            spriteProvider = sprite;
        }

        public static ParticleWizardry createParticle(class_638 clientWorld, class_243 vec3d) {
            return new ParticleLightning(clientWorld, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, spriteProvider);
        }

        @Nullable
        public class_703 createParticle(@NotNull class_2400 parameters, @NotNull class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ParticleLightning(world, x, y, z, spriteProvider);
        }
    }
}

