/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.renderer.entity;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.entity.construct.BubbleConstruct;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BubbleRenderer
extends class_897<BubbleConstruct> {
    private static final class_2960 BUBBLE_TEXTURE = new class_2960("textures/particle/bubble.png");
    private static final class_2960 ENTRAPMENT_TEXTURE = WizardryMainMod.location("textures/entity/entrapment.png");
    private static final float BUBBLE_SIZE_MULTIPLIER = 1.1f;

    public BubbleRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(@NotNull BubbleConstruct entity, float entityYaw, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 buffers, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22907(this.field_4676.method_24197());
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        class_2960 tex = this.getTextureLocation(entity);
        class_4588 vc = buffers.getBuffer(class_1921.method_23580((class_2960)tex));
        Matrix4f pose = poseStack.method_23760().method_23761();
        Matrix3f normal = poseStack.method_23760().method_23762();
        float size = this.calculateBubbleSize(entity);
        float top = size * 2.0f;
        this.addVertex(vc, pose, normal, -size, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(vc, pose, normal, size, 0.0f, 1.0f, 1.0f, packedLight);
        this.addVertex(vc, pose, normal, size, top, 1.0f, 0.0f, packedLight);
        this.addVertex(vc, pose, normal, -size, top, 0.0f, 0.0f, packedLight);
        poseStack.method_22909();
        super.method_3936((class_1297)entity, entityYaw, partialTicks, poseStack, buffers, packedLight);
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull BubbleConstruct construct) {
        return construct.isDarkOrb() ? ENTRAPMENT_TEXTURE : BUBBLE_TEXTURE;
    }

    private float calculateBubbleSize(BubbleConstruct entity) {
        class_1297 trapped = EntityUtil.getRider(entity);
        if (trapped != null) {
            float width = trapped.method_17681();
            float height = trapped.method_17682() / 2.0f;
            return Math.max(width, height) * 1.1f;
        }
        return 1.0f;
    }

    private void addVertex(class_4588 vc, Matrix4f pose, Matrix3f normal, float x, float y, float u, float v, int packedLight) {
        vc.method_22918(pose, x, y, 0.0f).method_1336(255, 255, 255, 200).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(packedLight).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
    }
}

