/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.sound;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.event.EBClientTickEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public abstract class SoundLoop
extends class_1101 {
    private static final Set<SoundLoop> activeLoops = new HashSet<SoundLoop>();
    private final class_1113 startPrimer;
    private final class_1113 start;
    private final class_1113 loop;
    private final class_1113 end;
    private boolean looping = false;
    private boolean needsRemoving = false;

    public SoundLoop(class_3414 start, class_3414 loop, class_3414 end, class_3419 category, float volume, ISoundFactory factory) {
        super(end, category, class_310.method_1551().field_1687.field_9229);
        this.startPrimer = factory.create(start, category, 1.0E-5f, false);
        this.start = factory.create(start, category, volume, false);
        this.loop = factory.create(loop, category, volume, true);
        this.end = factory.create(end, category, volume, false);
    }

    public static void addLoop(SoundLoop loop) {
        activeLoops.add(loop);
        class_310.method_1551().method_1483().method_4873(loop.startPrimer);
        class_310.method_1551().method_1483().method_4872(loop.start, 2);
    }

    protected static boolean hasActiveLoopMatching(Predicate<SoundLoop> predicate) {
        return activeLoops.stream().anyMatch(predicate);
    }

    public static void onClientTick(EBClientTickEvent event) {
        activeLoops.stream().filter(s -> s.needsRemoving).forEach(SoundLoop::stopStartAndLoop);
        activeLoops.removeIf(s -> s.needsRemoving);
        activeLoops.forEach(SoundLoop::method_16896);
    }

    public void method_16896() {
        if (!this.looping && !class_310.method_1551().method_1483().method_4877(this.startPrimer)) {
            EBLogger.warn("SoundLoop: Starting loop sound.", new Object[0]);
            class_310.method_1551().method_1483().method_4873(this.loop);
            this.looping = true;
        }
    }

    public void endLoop() {
        class_310.method_1551().method_1483().method_4873(this.end);
        this.needsRemoving = true;
    }

    protected void stopStartAndLoop() {
        class_310.method_1551().method_1483().method_4870(this.startPrimer);
        class_310.method_1551().method_1483().method_4870(this.start);
        class_310.method_1551().method_1483().method_4870(this.loop);
    }

    @FunctionalInterface
    public static interface ISoundFactory {
        public class_1113 create(class_3414 var1, class_3419 var2, float var3, boolean var4);
    }
}

