/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.sound;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.client.sound.MovingSoundEntity;
import com.binaris.wizardry.client.sound.SoundLoop;
import net.minecraft.class_1102;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2601;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public abstract class SoundLoopSpell
extends SoundLoop {
    final Spell spell;

    public SoundLoopSpell(class_3414 start, class_3414 loop, class_3414 end, float volume, SoundLoop.ISoundFactory factory, Spell spell) {
        super(start, loop, end, class_3419.field_15248, volume, factory);
        this.spell = spell;
    }

    public static boolean hasActiveLoop(class_1309 entity, Spell spell) {
        return SoundLoop.hasActiveLoopMatching(loop -> {
            if (!(loop instanceof SoundLoopSpellEntity)) return false;
            SoundLoopSpellEntity spellLoop = (SoundLoopSpellEntity)((Object)loop);
            if (spellLoop.source != entity) return false;
            if (spellLoop.spell != spell) return false;
            return true;
        });
    }

    protected abstract boolean stillCasting(Spell var1);

    @Override
    public void method_16896() {
        if (this.stillCasting(this.spell)) {
            super.method_16896();
        } else {
            this.endLoop();
        }
    }

    public static class SoundLoopSpellEntity
    extends SoundLoopSpell {
        private final class_1309 source;

        public SoundLoopSpellEntity(class_3414 start, class_3414 loop, class_3414 end, Spell spell, class_1309 source, float volume, float pitch) {
            super(start, loop, end, volume, (sound, category, v, repeat) -> new MovingSoundEntity<class_1309>(source, sound, category, v, pitch, repeat), spell);
            this.source = source;
        }

        @Override
        protected boolean stillCasting(Spell spell) {
            return EntityUtil.isCasting(this.source, spell);
        }
    }

    public static class SoundLoopSpellPosTimed
    extends SoundLoopSpellLocation {
        private int timeLeft;

        public SoundLoopSpellPosTimed(class_3414 start, class_3414 loop, class_3414 end, Spell spell, int duration, double x, double y, double z, float sndVolume, float sndPitch) {
            super(start, loop, end, spell, x, y, z, sndVolume, sndPitch);
            this.timeLeft = duration;
        }

        @Override
        public void method_16896() {
            super.method_16896();
            --this.timeLeft;
        }

        @Override
        protected boolean stillCasting(Spell spell) {
            return this.timeLeft > 0;
        }
    }

    public static class SoundLoopSpellDispenser
    extends SoundLoopSpellLocation {
        private final class_2601 source;

        public SoundLoopSpellDispenser(class_3414 start, class_3414 loop, class_3414 end, Spell spell, class_1937 world, double x, double y, double z, float sndVolume, float sndPitch) {
            super(start, loop, end, spell, x, y, z, sndVolume, sndPitch);
            class_2586 tileentity = world.method_8321(class_2338.method_49637((double)x, (double)y, (double)z));
            if (!(tileentity instanceof class_2601)) {
                throw new NullPointerException(String.format("Playing continuous spell sound: no dispenser found at %s, %s, %s", x, y, z));
            }
            this.source = (class_2601)tileentity;
        }

        @Override
        protected boolean stillCasting(Spell spell) {
            return false;
        }
    }

    public static abstract class SoundLoopSpellLocation
    extends SoundLoopSpell {
        public SoundLoopSpellLocation(class_3414 start, class_3414 loop, class_3414 end, Spell spell, double x, double y, double z, float sndVolume, final float sndPitch) {
            super(start, loop, end, sndVolume, (sound, category, v, r) -> new class_1102(sound, category, class_310.method_1551().field_1687.field_9229){
                {
                    super(soundEvent, source, random);
                    this.field_5439 = (float)this.field_5439;
                    this.field_5450 = (float)this.field_5450;
                    this.field_5449 = (float)this.field_5449;
                    this.field_5446 = r;
                    this.field_5442 = v;
                    this.field_5441 = sndPitch;
                }
            }, spell);
        }
    }
}

