/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.event.EBDiscoverSpellEvent;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.ForfeitRegistry;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class Forfeit {
    protected final class_3414 sound;
    private final class_2960 name;
    private final Element element;
    private final SpellTier spellTier;
    @Nullable
    private final BiConsumer<class_1937, class_1657> effect;

    public Forfeit(class_2960 name, Element element, SpellTier spellTier, @Nullable BiConsumer<class_1937, class_1657> effect) {
        this.name = name;
        this.sound = class_3414.method_47908((class_2960)new class_2960(name.method_12836(), "forfeit." + name.method_12832()));
        this.element = element;
        this.spellTier = spellTier;
        this.effect = effect;
    }

    public Forfeit(String name, Element element, SpellTier spellTier, @Nullable BiConsumer<class_1937, class_1657> effect) {
        this(WizardryMainMod.location(name), element, spellTier, effect);
    }

    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        class_1657 p;
        class_1657 player;
        class_1309 class_13092 = event.getCaster();
        class_1657 class_16572 = player = class_13092 instanceof class_1657 ? (p = (class_1657)class_13092) : null;
        if (player == null || player.method_7337()) {
            return;
        }
        if (event.getSource() != SpellCastEvent.Source.WAND && event.getSource() != SpellCastEvent.Source.SCROLL) {
            return;
        }
        SpellManagerData spellData = Services.OBJECT_DATA.getSpellManagerData(player);
        WizardData wizardData = Services.OBJECT_DATA.getWizardData(player);
        if (spellData.hasSpellBeenDiscovered(event.getSpell())) {
            return;
        }
        ForfeitResult result = Forfeit.calculateForfeit(player, spellData, wizardData, event.getSpell());
        if (!result.shouldTrigger) {
            return;
        }
        event.setCanceled(true);
        Forfeit.applyForfeitToPlayer(event, player, result.forfeit);
    }

    private static ForfeitResult calculateForfeit(class_1657 player, SpellManagerData spellData, WizardData wizardData, Spell spell) {
        float chance = (float)EBConfig.forfeitChance;
        if (EBAccessoriesIntegration.isEquipped(player, EBItems.AMULET_WISDOM.get())) {
            chance *= 0.5f;
        }
        boolean isUndiscovered = !spellData.hasSpellBeenDiscovered(spell);
        Random random = wizardData.getRandom();
        float roll = random.nextFloat();
        Forfeit forfeit = ForfeitRegistry.getRandomForfeit(random, spell.getTier(), spell.getElement());
        boolean shouldTrigger = roll < chance && isUndiscovered;
        return new ForfeitResult(shouldTrigger, forfeit);
    }

    private static void applyForfeitToPlayer(SpellCastEvent.Pre event, class_1657 player, Forfeit forfeit) {
        class_2561 message;
        if (forfeit == null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"forfeit.ebwizardry.do_nothing"));
            return;
        }
        forfeit.apply(event.getLevel(), player);
        Forfeit.consumeResourceForForfeit(event, player);
        if (player instanceof class_3222) {
            EBAdvancementTriggers.SPELL_FAILURE.triggerFor(player);
        }
        EntityUtil.playSoundAtPlayer(player, forfeit.getSound(), 1.0f, 1.0f);
        class_2561 class_25612 = message = event.getSource() == SpellCastEvent.Source.WAND ? forfeit.getMessageForWand() : forfeit.getMessageForScroll();
        if (!player.method_37908().field_9236) {
            player.method_7353(message, true);
        }
    }

    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        class_1309 class_13092 = event.getCaster();
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            EBAdvancementTriggers.CAST_SPELL.trigger(serverPlayer, event.getSpell(), player.method_5998(player.method_6058()));
        }
        if (!event.getLevel().method_8608()) {
            Forfeit.discoverSpell(player, event.getSpell());
        }
    }

    private static void discoverSpell(class_1657 player, Spell spell) {
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
        boolean eventCancelled = WizardryEventBus.getInstance().fire(new EBDiscoverSpellEvent(player, spell, EBDiscoverSpellEvent.Source.CASTING));
        if (eventCancelled || !data.discoverSpell(spell)) {
            return;
        }
        if (!player.method_37908().field_9236 && !player.method_7337()) {
            EntityUtil.playSoundAtPlayer(player, EBSounds.MISC_DISCOVER_SPELL.get(), 1.25f, 1.0f);
            class_5250 message = class_2561.method_43469((String)"spell.discover", (Object[])new Object[]{spell.getDescriptionFormatted()});
            player.method_43496((class_2561)message);
        }
    }

    private static void consumeResourceForForfeit(SpellCastEvent.Pre event, class_1657 player) {
        class_1799 stack = Forfeit.findCastingItem(player);
        if (stack.method_7960()) {
            return;
        }
        if (event.getSource() == SpellCastEvent.Source.SCROLL) {
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
        } else {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof IManaStoringItem) {
                IManaStoringItem manaItem = (IManaStoringItem)class_17922;
                int cost = (int)((float)event.getSpell().getCost() * event.getModifiers().get("cost") + 0.1f);
                manaItem.consumeMana(stack, cost, (class_1309)player);
            }
        }
    }

    private static class_1799 findCastingItem(class_1657 player) {
        class_1799 mainHand = player.method_6047();
        if (mainHand.method_7909() instanceof ISpellCastingItem) {
            return mainHand;
        }
        class_1799 offHand = player.method_6079();
        if (offHand.method_7909() instanceof ISpellCastingItem) {
            return offHand;
        }
        return class_1799.field_8037;
    }

    public void apply(class_1937 world, class_1657 player) {
        if (this.effect != null) {
            this.effect.accept(world, player);
        }
    }

    public class_2561 getMessage(class_2561 implementName) {
        return class_2561.method_43469((String)("forfeit." + this.name.method_12836() + "." + this.name.method_12832()), (Object[])new Object[]{implementName});
    }

    public class_2561 getMessageForWand() {
        return this.getMessage((class_2561)class_2561.method_43471((String)"item.ebwizardry.wand.generic"));
    }

    public class_2561 getMessageForScroll() {
        return this.getMessage((class_2561)class_2561.method_43471((String)"item.ebwizardry.scroll.generic"));
    }

    public class_2960 getName() {
        return this.name;
    }

    public class_3414 getSound() {
        return this.sound;
    }

    public Element getElement() {
        return this.element;
    }

    public SpellTier getSpellTier() {
        return this.spellTier;
    }

    private record ForfeitResult(boolean shouldTrigger, Forfeit forfeit) {
    }
}

