/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.Forfeit;
import com.binaris.wizardry.content.entity.ArrowRainConstruct;
import com.binaris.wizardry.content.entity.MeteorEntity;
import com.binaris.wizardry.content.entity.construct.BlizzardConstruct;
import com.binaris.wizardry.content.entity.construct.HailstormConstruct;
import com.binaris.wizardry.content.entity.construct.IceSpikeConstruct;
import com.binaris.wizardry.content.entity.construct.LightningSigilConstruct;
import com.binaris.wizardry.content.entity.living.IceGiant;
import com.binaris.wizardry.content.entity.living.IceWraith;
import com.binaris.wizardry.content.entity.living.LightningWraith;
import com.binaris.wizardry.content.entity.living.ShadowWraith;
import com.binaris.wizardry.content.entity.living.StormElemental;
import com.binaris.wizardry.content.entity.projectile.FireBombEntity;
import com.binaris.wizardry.content.spell.necromancy.Banish;
import com.binaris.wizardry.core.mixin.accessor.FallingBlockEntityAccessor;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1477;
import net.minecraft.class_1538;
import net.minecraft.class_1540;
import net.minecraft.class_1545;
import net.minecraft.class_1634;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ForfeitRegistry {
    private static final Set<Forfeit> FORFEITS = new HashSet<Forfeit>();

    public static void create(String name, SpellTier tier, Element element, BiConsumer<class_1937, class_1657> effect) {
        ForfeitRegistry.create(new Forfeit(name, element, tier, effect));
    }

    public static void create(class_2960 location, SpellTier tier, Element element, BiConsumer<class_1937, class_1657> effect) {
        ForfeitRegistry.create(new Forfeit(location, element, tier, effect));
    }

    public static void create(Forfeit forfeit) {
        FORFEITS.add(forfeit);
    }

    public static Set<Forfeit> getForfeits() {
        return FORFEITS;
    }

    public static Forfeit getRandomForfeit(Random random, SpellTier tier, Element element) {
        List<Forfeit> forfeits = FORFEITS.stream().filter(forfeit -> forfeit.getSpellTier() == tier && forfeit.getElement() == element).toList();
        if (forfeits.isEmpty()) {
            EBLogger.warn("No forfeits with tier {} and element {}!", tier, element);
            return null;
        }
        return forfeits.get(random.nextInt(forfeits.size()));
    }

    public static void register() {
        ForfeitRegistry.create("burn_self", SpellTiers.NOVICE, Elements.FIRE, (class_1937 w, class_1657 p) -> p.method_5639(5));
        ForfeitRegistry.create("firebomb", SpellTiers.APPRENTICE, Elements.FIRE, (class_1937 w, class_1657 p) -> ForfeitRegistry.summon(w, p.method_24515(), (class_1297)new FireBombEntity((class_1937)w), 0.0, 5.0, 0.0));
        ForfeitRegistry.create("explode", SpellTiers.ADVANCED, Elements.FIRE, (class_1937 w, class_1657 p) -> w.method_8437(null, p.method_23317(), p.method_23318(), p.method_23321(), 2.0f, class_1937.class_7867.field_40888));
        ForfeitRegistry.create("blazes", SpellTiers.ADVANCED, Elements.FIRE, (class_1937 w, class_1657 p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((class_1297)p, 4, 2), (class_1297)new class_1545(class_1299.field_6099, w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("burn_surroundings", SpellTiers.MASTER, Elements.FIRE, (class_1937 w, class_1657 p) -> {
            if (w.field_9236 || !EntityUtil.canDamageBlocks((class_1309)p, w)) {
                return;
            }
            BlockUtil.getBlockSphere(p.method_24515(), 6.0).stream().filter(pos -> w.field_9229.method_43056() && w.method_22347(pos) && BlockUtil.canPlaceBlock((class_1309)p, w, pos)).forEach(pos -> w.method_8501(pos, class_2246.field_10036.method_9564()));
        });
        ForfeitRegistry.create("meteors", SpellTiers.MASTER, Elements.FIRE, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                for (int i = 0; i < 5; ++i) {
                    w.method_8649((class_1297)new MeteorEntity((class_1937)w, p.method_23317() + w.field_9229.method_43058() * 16.0 - 8.0, p.method_23318() + 40.0 + w.field_9229.method_43058() * 30.0, p.method_23321() + w.field_9229.method_43058() * 16.0 - 8.0, 1.0f, EntityUtil.canDamageBlocks((class_1309)p, w)));
                }
            }
        });
        ForfeitRegistry.create("freeze_self", SpellTiers.NOVICE, Elements.ICE, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(EBMobEffects.FROST.get(), 200));
            }
        });
        ForfeitRegistry.create("freeze_self_2", SpellTiers.NOVICE, Elements.ICE, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(EBMobEffects.FROST.get(), 300, 1));
            }
        });
        ForfeitRegistry.create("ice_spikes", SpellTiers.APPRENTICE, Elements.ICE, (class_1937 w, class_1657 p) -> {
            if (w.field_9236) {
                return;
            }
            for (int i = 0; i < 5; ++i) {
                IceSpikeConstruct iceSpike = new IceSpikeConstruct((class_1937)w);
                double x = p.method_23317() + 2.0 - (double)(w.field_9229.method_43057() * 4.0f);
                double z = p.method_23321() + 2.0 - (double)(w.field_9229.method_43057() * 4.0f);
                Integer y = BlockUtil.getNearestSurface(w, class_2338.method_49637((double)x, (double)p.method_23318(), (double)z), class_2350.field_11036, 2, true, BlockUtil.SurfaceCriteria.basedOn(ForfeitRegistry::isCollisionShapeFullBlock));
                iceSpike.lifetime = 45 + w.field_9229.method_43048(15);
                if (y == null) break;
                iceSpike.setFacing(class_2350.field_11036);
                iceSpike.method_5814(x, y.intValue(), z);
                w.method_8649((class_1297)iceSpike);
            }
        });
        ForfeitRegistry.create("blizzard", SpellTiers.ADVANCED, Elements.ICE, (class_1937 w, class_1657 p) -> ForfeitRegistry.summon(w, p.method_24515(), new BlizzardConstruct((class_1937)w), 0.0, 0.0, 0.0));
        ForfeitRegistry.create("ice_wraiths", SpellTiers.ADVANCED, Elements.ICE, (class_1937 w, class_1657 p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((class_1297)p, 4, 2), (class_1297)new IceWraith((class_1937)w), 0.0, 0.0, 0.0)));
        ForfeitRegistry.create("hailstorm", SpellTiers.MASTER, Elements.ICE, (class_1937 w, class_1657 p) -> ForfeitRegistry.summon(w, p.method_24515(), new HailstormConstruct((class_1937)w), 0.0, 5.0, -3.0));
        ForfeitRegistry.create("ice_giant", SpellTiers.MASTER, Elements.ICE, (class_1937 w, class_1657 p) -> ForfeitRegistry.summon(w, p.method_24515(), (class_1297)new IceGiant((class_1937)w), p.method_5720().field_1352 * 4.0, 0.0, p.method_5720().field_1350 * 4.0));
        ForfeitRegistry.create("thunder", SpellTiers.NOVICE, Elements.LIGHTNING, (class_1937 w, class_1657 p) -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((class_1297)p, 4, 2), (class_1297)new LightningWraith((class_1937)w), 0.5, 0.0, 0.5));
        ForfeitRegistry.create("storm", SpellTiers.APPRENTICE, Elements.LIGHTNING, (class_1937 w, class_1657 p) -> {
            if (!Spells.INVOKE_WEATHER.isEnabled(SpellContext.WANDS)) {
                return;
            }
            int shortWeatherTime = (100 + new Random().nextInt(200)) * 20;
            if (!w.field_9236) {
                ((class_3218)w).method_27910(0, shortWeatherTime, true, true);
            }
        });
        ForfeitRegistry.create("lightning_sigils", SpellTiers.APPRENTICE, Elements.LIGHTNING, (class_1937 w, class_1657 p) -> {
            for (class_2350 direction : BlockUtil.getHorizontals()) {
                class_2338 pos = p.method_24515().method_10079(direction, 2);
                Integer y = BlockUtil.getNearestFloor(w, pos, 2);
                if (y == null) continue;
                ForfeitRegistry.summon(w, pos.method_33096(y.intValue()), new LightningSigilConstruct((class_1937)w), 0.5, 0.0, 0.5);
            }
        });
        ForfeitRegistry.create("lightning", SpellTiers.ADVANCED, Elements.LIGHTNING, (class_1937 w, class_1657 p) -> ForfeitRegistry.summon(w, p.method_24515(), (class_1297)new class_1538(class_1299.field_6112, w), 0.0, 0.0, 0.0));
        ForfeitRegistry.create("lightning_wraiths", SpellTiers.ADVANCED, Elements.LIGHTNING, (class_1937 w, class_1657 p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((class_1297)p, 4, 2), (class_1297)new LightningWraith((class_1937)w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("storm_elemental", SpellTiers.MASTER, Elements.LIGHTNING, (class_1937 w, class_1657 p) -> Arrays.stream(BlockUtil.getHorizontals()).forEach(direction -> ForfeitRegistry.summon(w, p.method_24515().method_10079(direction, 3), (class_1297)new StormElemental((class_1937)w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("nausea", SpellTiers.NOVICE, Elements.NECROMANCY, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(class_1294.field_5916, 400));
            }
        });
        ForfeitRegistry.create("zombie_horde", SpellTiers.APPRENTICE, Elements.NECROMANCY, (class_1937 w, class_1657 p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((class_1297)p, 4, 2), (class_1297)new class_1642(class_1299.field_6051, w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("wither_self", SpellTiers.ADVANCED, Elements.NECROMANCY, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(class_1294.field_5920, 400));
            }
        });
        ForfeitRegistry.create("cripple_self", SpellTiers.ADVANCED, Elements.NECROMANCY, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(class_1294.field_5909, 400, 2));
            }
        });
        ForfeitRegistry.create("shadow_wraiths", SpellTiers.MASTER, Elements.NECROMANCY, (class_1937 w, class_1657 p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((class_1297)p, 4, 2), (class_1297)new ShadowWraith((class_1937)w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("squid", SpellTiers.NOVICE, Elements.EARTH, (class_1937 w, class_1657 p) -> ForfeitRegistry.summon(w, p.method_24515(), (class_1297)new class_1477(class_1299.field_6114, w), 0.0, 3.0, 0.0));
        ForfeitRegistry.create("uproot_plants", SpellTiers.APPRENTICE, Elements.EARTH, (class_1937 w, class_1657 p) -> {
            if (w.method_8608()) {
                return;
            }
            List<class_2338> sphere = BlockUtil.getBlockSphere(p.method_24515(), 5.0);
            sphere.removeIf(pos -> !BlockUtil.canBreak(p, w, pos, false));
            sphere.forEach(pos -> w.method_22352(pos, true));
        });
        ForfeitRegistry.create("poison_self", SpellTiers.APPRENTICE, Elements.EARTH, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(class_1294.field_5899, 400, 1));
            }
        });
        ForfeitRegistry.create("flood", SpellTiers.ADVANCED, Elements.EARTH, (class_1937 w, class_1657 p) -> {
            if (w.method_8608()) {
                return;
            }
            List<class_2338> sphere = BlockUtil.getBlockSphere(p.method_24515().method_10084(), 2.0);
            sphere.removeIf(pos -> !BlockUtil.canBlockBeReplaced(w, pos, true) || !BlockUtil.canPlaceBlock((class_1309)p, w, pos));
            sphere.forEach(pos -> w.method_8501(pos, class_2246.field_10382.method_9564()));
        });
        ForfeitRegistry.create("bury_self", SpellTiers.MASTER, Elements.EARTH, (class_1937 w, class_1657 p) -> {
            if (w.field_9236) {
                return;
            }
            List<class_2338> sphere = BlockUtil.getBlockSphere(p.method_24515(), 4.0);
            sphere.forEach(pos -> {
                class_1540 blockEntity = FallingBlockEntityAccessor.createFallingBlockEntity(w, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_2246.field_10566.method_9564());
                blockEntity.method_18800(blockEntity.method_18798().field_1352, 0.3 * (double)(4 - (p.method_24515().method_10264() - pos.method_10264())), blockEntity.method_18798().field_1350);
                w.method_8649((class_1297)blockEntity);
            });
        });
        ForfeitRegistry.create("spill_inventory", SpellTiers.NOVICE, Elements.SORCERY, (class_1937 w, class_1657 p) -> {
            for (int i = 0; i < p.method_31548().field_7547.size(); ++i) {
                class_1799 stack = (class_1799)p.method_31548().field_7547.get(i);
                if (stack.method_7960()) continue;
                p.method_7329(stack, true, false);
                p.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
            }
        });
        ForfeitRegistry.create("teleport_self", SpellTiers.APPRENTICE, Elements.SORCERY, (class_1937 w, class_1657 p) -> ((Banish)Spells.BANISH).teleport((class_1309)p, (class_1937)w, 8.0 + w.field_9229.method_43058() * 8.0));
        ForfeitRegistry.create("levitate_self", SpellTiers.ADVANCED, Elements.SORCERY, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(class_1294.field_5902, 200));
            }
        });
        ForfeitRegistry.create("vex_horde", SpellTiers.ADVANCED, Elements.SORCERY, (class_1937 w, class_1657 p) -> IntStream.range(0, 4).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((class_1297)p, 4, 2), (class_1297)new class_1634(class_1299.field_6059, w), 0.5, 1.0, 0.5)));
        ForfeitRegistry.create("arrow_rain", SpellTiers.MASTER, Elements.SORCERY, (class_1937 w, class_1657 p) -> ForfeitRegistry.summon(w, p.method_24515(), new ArrowRainConstruct((class_1937)w), 0.0, 5.0, -3.0));
        ForfeitRegistry.create("damage_self", SpellTiers.NOVICE, Elements.HEALING, (class_1937 w, class_1657 p) -> p.method_5643(p.method_48923().method_48831(), 4.0f));
        ForfeitRegistry.create("spill_armour", SpellTiers.NOVICE, Elements.HEALING, (class_1937 w, class_1657 p) -> IntStream.range(0, p.method_31548().field_7548.size()).forEach(i -> {
            class_1799 stack = (class_1799)p.method_31548().field_7548.get(i);
            if (!stack.method_7960()) {
                p.method_7329(stack, true, false);
                p.method_31548().field_7548.set(i, (Object)class_1799.field_8037);
            }
        }));
        ForfeitRegistry.create("hunger", SpellTiers.APPRENTICE, Elements.HEALING, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(class_1294.field_5903, 400, 4));
            }
        });
        ForfeitRegistry.create("blind_self", SpellTiers.APPRENTICE, Elements.HEALING, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(class_1294.field_5919, 200));
            }
        });
        ForfeitRegistry.create("weaken_self", SpellTiers.ADVANCED, Elements.HEALING, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(class_1294.field_5911, 600, 3));
            }
        });
        ForfeitRegistry.create("jam_self", SpellTiers.ADVANCED, Elements.HEALING, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(EBMobEffects.ARCANE_JAMMER.get(), 300));
            }
        });
        ForfeitRegistry.create("curse_self", SpellTiers.MASTER, Elements.HEALING, (class_1937 w, class_1657 p) -> {
            if (!w.field_9236) {
                p.method_6092(new class_1293(EBMobEffects.CURSE_OF_UNDEATH.get(), Integer.MAX_VALUE));
            }
        });
    }

    public static boolean isCollisionShapeFullBlock(class_1922 blockGetter, class_2338 pos) {
        return blockGetter.method_8320(pos).method_26234(blockGetter, pos);
    }

    public static void summon(class_1937 world, @Nullable class_2338 pos, class_1297 entity, double xOffset, double yOffset, double zOffset) {
        if (world.field_9236) {
            return;
        }
        if (pos == null) {
            return;
        }
        entity.method_5814((double)pos.method_10263() + xOffset, (double)pos.method_10264() + yOffset, (double)pos.method_10260() + zOffset);
        world.method_8649(entity);
    }
}

