/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.advancement;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.content.advancement.SpellPredicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_179;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_5257;
import org.jetbrains.annotations.NotNull;

public class SpellCastTrigger
implements class_179<TriggerInstance> {
    private final class_2960 ID;
    private final Map<class_2985, Listeners> listeners = Maps.newHashMap();

    public SpellCastTrigger() {
        this.ID = WizardryMainMod.location("cast_spell");
    }

    @NotNull
    public class_2960 method_794() {
        return this.ID;
    }

    public void method_792(@NotNull class_2985 advancements, @NotNull class_179.class_180<TriggerInstance> listener) {
        this.listeners.computeIfAbsent(advancements, Listeners::new).add(listener);
    }

    public void method_793(@NotNull class_2985 advancements, @NotNull class_179.class_180<TriggerInstance> listener) {
        Listeners li = this.listeners.get(advancements);
        if (li == null) {
            return;
        }
        li.remove(listener);
        if (li.isEmpty()) {
            this.listeners.remove(advancements);
        }
    }

    public void method_791(@NotNull class_2985 advancements) {
        this.listeners.remove(advancements);
    }

    @NotNull
    public TriggerInstance createInstance(@NotNull JsonObject json, @NotNull class_5257 context) {
        return new TriggerInstance(this.ID, SpellPredicate.deserialize(json.get("spell")), class_2073.method_8969((JsonElement)json.get("item")), json, context);
    }

    public void trigger(class_3222 player, Spell spell, class_1799 stack) {
        Optional.ofNullable(this.listeners.get(player.method_14236())).ifPresent(li -> li.trigger(spell, stack));
    }

    static class Listeners {
        private final class_2985 playerAdvancements;
        private final Set<class_179.class_180<TriggerInstance>> listeners = Sets.newHashSet();

        public Listeners(class_2985 advancements) {
            this.playerAdvancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(class_179.class_180<TriggerInstance> listener) {
            this.listeners.add(listener);
        }

        public void remove(class_179.class_180<TriggerInstance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Spell spell, class_1799 stack) {
            List<class_179.class_180> list = this.listeners.stream().filter(li -> ((TriggerInstance)li.method_797()).test(spell, stack)).toList();
            list.forEach(li -> li.method_796(this.playerAdvancements));
        }
    }

    public static class TriggerInstance
    extends class_195 {
        private final SpellPredicate spell;
        private final class_2073 item;

        public TriggerInstance(class_2960 criterion, SpellPredicate spell, class_2073 item, JsonObject json, class_5257 context) {
            super(criterion, class_2048.method_51705((JsonObject)json, (String)"spell", (class_5257)context));
            this.spell = spell;
            this.item = item;
        }

        public boolean test(Spell spell, class_1799 stack) {
            return this.spell.test(spell) && this.item.method_8970(stack);
        }
    }
}

