/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.advancement;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.event.EBDiscoverSpellEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.content.advancement.SpellPredicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_179;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

public class SpellDiscoveryTrigger
implements class_179<TriggerInstance> {
    static final class_2960 ID = WizardryMainMod.location("discover_spell");
    private final Map<class_2985, Listeners> listeners = Maps.newHashMap();

    @NotNull
    public class_2960 method_794() {
        return ID;
    }

    public void method_792(@NotNull class_2985 advancements, @NotNull class_179.class_180<TriggerInstance> listener) {
        this.listeners.computeIfAbsent(advancements, Listeners::new).add(listener);
    }

    public void method_793(@NotNull class_2985 advancements, @NotNull class_179.class_180<TriggerInstance> listener) {
        Listeners li = this.listeners.get(advancements);
        if (li == null) {
            return;
        }
        li.remove(listener);
        if (li.isEmpty()) {
            this.listeners.remove(advancements);
        }
    }

    public void method_791(@NotNull class_2985 advancements) {
        this.listeners.remove(advancements);
    }

    @NotNull
    public TriggerInstance createInstance(@NotNull JsonObject json, @NotNull class_5257 context) {
        String s = class_3518.method_15265((JsonObject)json, (String)"source");
        EBDiscoverSpellEvent.Source source = EBDiscoverSpellEvent.Source.byName(s);
        if (source == null) {
            throw new JsonSyntaxException("No such spell discovery source: " + s);
        }
        return new TriggerInstance(SpellPredicate.deserialize(json.get("spell")), source, json, context);
    }

    public void trigger(class_3222 player, Spell spell, EBDiscoverSpellEvent.Source source) {
        Optional.ofNullable(this.listeners.get(player.method_14236())).ifPresent(listeners -> listeners.trigger(spell, source));
    }

    static class Listeners {
        private final class_2985 playerAdvancements;
        private final Set<class_179.class_180<TriggerInstance>> listeners = Sets.newHashSet();

        public Listeners(class_2985 advancements) {
            this.playerAdvancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(class_179.class_180<TriggerInstance> listener) {
            this.listeners.add(listener);
        }

        public void remove(class_179.class_180<TriggerInstance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Spell spell, EBDiscoverSpellEvent.Source source) {
            List<class_179.class_180> list = this.listeners.stream().filter(li -> ((TriggerInstance)li.method_797()).test(spell, source)).toList();
            list.forEach(li -> li.method_796(this.playerAdvancements));
        }
    }

    public static class TriggerInstance
    extends class_195 {
        private final SpellPredicate spell;
        private final EBDiscoverSpellEvent.Source source;

        public TriggerInstance(SpellPredicate spell, EBDiscoverSpellEvent.Source source, JsonObject json, class_5257 context) {
            super(ID, class_2048.method_51705((JsonObject)json, (String)"player", (class_5257)context));
            this.spell = spell;
            this.source = source;
        }

        public TriggerInstance(SpellPredicate spell, EBDiscoverSpellEvent.Source source) {
            super(ID, class_5258.field_24388);
            this.spell = spell;
            this.source = source;
        }

        public static TriggerInstance discoverSpell(EBDiscoverSpellEvent.Source source) {
            return new TriggerInstance(SpellPredicate.any(), source);
        }

        public boolean test(Spell spell, EBDiscoverSpellEvent.Source source) {
            return this.spell.test(spell) && source == this.source;
        }

        @NotNull
        public JsonObject method_807(@NotNull class_5267 conditions) {
            JsonObject jsonobject = super.method_807(conditions);
            jsonobject.addProperty("source", this.source.name().toLowerCase());
            JsonElement spellJson = this.spell.serialize();
            if (spellJson != null) {
                jsonobject.add("spell", spellJson);
            }
            return jsonobject;
        }
    }
}

