/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.advancement;

import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.core.platform.Services;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class SpellPredicate {
    private final Spell spell;
    private final Set<SpellTier> tiers;
    private final Set<Element> elements;

    public SpellPredicate(@Nullable Spell spell, Set<SpellTier> tiers, Set<Element> elements) {
        this.spell = spell;
        this.tiers = tiers;
        this.elements = elements;
    }

    public static SpellPredicate any() {
        HashSet<SpellTier> trs = new HashSet<SpellTier>(Services.REGISTRY_UTIL.getTiers());
        HashSet<Element> els = new HashSet<Element>(Services.REGISTRY_UTIL.getElements());
        return new SpellPredicate(null, trs, els);
    }

    public static SpellPredicate deserialize(@Nullable JsonElement element) {
        Set<Element> elements;
        Set<SpellTier> tiers;
        if (element == null || element.isJsonNull()) {
            return SpellPredicate.any();
        }
        JsonObject json = class_3518.method_15295((JsonElement)element, (String)"spell");
        Spell spell = Optional.ofNullable(json.get("spell")).map(JsonElement::getAsString).map(class_2960::method_12829).map(Services.REGISTRY_UTIL::getSpell).orElse(null);
        if (json.has("spell") && spell == null) {
            throw new JsonSyntaxException("Unknown spell id '" + json.get("spell").getAsString() + "'");
        }
        if (json.has("tiers")) {
            tiers = json.getAsJsonArray("tiers").asList().stream().map(JsonElement::getAsString).map(class_2960::method_12829).map(Services.REGISTRY_UTIL::getTier).collect(Collectors.toSet());
            if (tiers.isEmpty()) {
                tiers = new HashSet<SpellTier>(Services.REGISTRY_UTIL.getTiers());
            }
        } else {
            tiers = new HashSet<SpellTier>(Services.REGISTRY_UTIL.getTiers());
        }
        if (json.has("elements")) {
            elements = json.getAsJsonArray("elements").asList().stream().map(JsonElement::getAsString).map(class_2960::method_12829).map(Services.REGISTRY_UTIL::getElement).collect(Collectors.toSet());
            if (elements.isEmpty()) {
                elements = new HashSet<Element>(Services.REGISTRY_UTIL.getElements());
            }
        } else {
            elements = new HashSet<Element>(Services.REGISTRY_UTIL.getElements());
        }
        return new SpellPredicate(spell, tiers, elements);
    }

    public boolean test(Spell spell) {
        if (this.spell != null && !this.spell.equals(spell)) {
            return false;
        }
        if (!this.tiers.contains(spell.getTier())) {
            return false;
        }
        return this.elements.contains(spell.getElement());
    }

    public JsonElement serialize() {
        class_2960 spellKey;
        HashSet<SpellTier> allTiers = new HashSet<SpellTier>(Services.REGISTRY_UTIL.getTiers());
        HashSet<Element> allElements = new HashSet<Element>(Services.REGISTRY_UTIL.getElements());
        if (this.spell == null && this.tiers.equals(allTiers) && this.elements.equals(allElements)) {
            return null;
        }
        JsonObject json = new JsonObject();
        if (this.spell != null && (spellKey = Services.REGISTRY_UTIL.getSpell(this.spell)) != null) {
            json.addProperty("spell", spellKey.toString());
        }
        if (!this.tiers.equals(allTiers) && !this.tiers.isEmpty()) {
            JsonArray tiersArray = new JsonArray();
            for (SpellTier tier : this.tiers) {
                class_2960 tierKey = Services.REGISTRY_UTIL.getTier(tier);
                if (tierKey == null) continue;
                tiersArray.add(tierKey.toString());
            }
            json.add("tiers", (JsonElement)tiersArray);
        }
        if (!this.elements.equals(allElements) && !this.elements.isEmpty()) {
            JsonArray elementsArray = new JsonArray();
            for (Element element : this.elements) {
                class_2960 elementKey = Services.REGISTRY_UTIL.getElement(element);
                if (elementKey == null) continue;
                elementsArray.add(elementKey.toString());
            }
            json.add("elements", (JsonElement)elementsArray);
        }
        return json;
    }
}

