/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.advancement;

import com.binaris.wizardry.WizardryMainMod;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_179;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

public class WizardryContainerTrigger
implements class_179<TriggerInstance> {
    private final class_2960 ID;
    private final Map<class_2985, Listeners> listeners = Maps.newHashMap();

    public WizardryContainerTrigger(String name) {
        this.ID = WizardryMainMod.location(name);
    }

    @NotNull
    public class_2960 method_794() {
        return this.ID;
    }

    public void method_792(@NotNull class_2985 advancements, @NotNull class_179.class_180<TriggerInstance> listener) {
        this.listeners.computeIfAbsent(advancements, Listeners::new).add(listener);
    }

    public void method_793(@NotNull class_2985 advancements, @NotNull class_179.class_180<TriggerInstance> listener) {
        Listeners li = this.listeners.get(advancements);
        if (li == null) {
            return;
        }
        li.remove(listener);
        if (li.isEmpty()) {
            this.listeners.remove(advancements);
        }
    }

    public void method_791(@NotNull class_2985 advancements) {
        this.listeners.remove(advancements);
    }

    @NotNull
    public TriggerInstance createInstance(@NotNull JsonObject json, @NotNull class_5257 context) {
        return new TriggerInstance(this.ID, class_2073.method_8969((JsonElement)json.get("item")), json, context);
    }

    public void trigger(class_3222 player, class_1799 stack) {
        Optional.ofNullable(this.listeners.get(player.method_14236())).ifPresent(li -> li.trigger(stack));
    }

    static class Listeners {
        private final class_2985 playerAdvancements;
        private final Set<class_179.class_180<TriggerInstance>> listeners = Sets.newHashSet();

        public Listeners(class_2985 advancements) {
            this.playerAdvancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(class_179.class_180<TriggerInstance> listener) {
            this.listeners.add(listener);
        }

        public void remove(class_179.class_180<TriggerInstance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(class_1799 stack) {
            List<class_179.class_180> list = this.listeners.stream().filter(li -> ((TriggerInstance)li.method_797()).test(stack)).toList();
            list.forEach(li -> li.method_796(this.playerAdvancements));
        }
    }

    public static class TriggerInstance
    extends class_195 {
        private final class_2073 item;

        public TriggerInstance(class_2960 criterionIn, class_2073 item, JsonObject json, class_5257 context) {
            super(criterionIn, class_2048.method_51705((JsonObject)json, (String)"player", (class_5257)context));
            this.item = item;
        }

        public TriggerInstance(class_2960 criterionIn, class_2073 item) {
            super(criterionIn, class_5258.field_24388);
            this.item = item;
        }

        @NotNull
        public JsonObject method_807(@NotNull class_5267 conditions) {
            JsonObject jsonobject = super.method_807(conditions);
            jsonobject.add("item", this.item.method_8971());
            return jsonobject;
        }

        public boolean test(class_1799 stack) {
            return this.item.method_8970(stack);
        }
    }
}

