/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.blockentity;

import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.item.CrystalItem;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.content.menu.ArcaneWorkbenchMenu;
import com.binaris.wizardry.setup.registries.EBBlockEntities;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.HashSet;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcaneWorkbenchBlockEntity
extends class_2624 {
    public float timer = 0.0f;
    public float rot;
    public float oRot;
    public float tRot;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)11, (Object)class_1799.field_8037);

    public ArcaneWorkbenchBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EBBlockEntities.ARCANE_WORKBENCH.get(), blockPos, blockState);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, ArcaneWorkbenchBlockEntity entity) {
        class_1799 stack = entity.method_5438(9);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IManaStoringItem) {
            IManaStoringItem manaItem = (IManaStoringItem)class_17922;
            if (!level.field_9236 && !manaItem.isManaFull(stack) && level.method_8510() % 50L == 0L) {
                manaItem.rechargeMana(stack, WandHelper.getUpgradeLevel(stack, EBItems.CONDENSER_UPGRADE.get()));
            }
        }
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, ArcaneWorkbenchBlockEntity entity) {
        float rotDiff;
        if (!level.field_9236) {
            return;
        }
        entity.timer += 1.0f;
        entity.oRot = entity.rot;
        class_1657 player = level.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 3.0, false);
        if (player != null) {
            double dx = player.method_23317() - ((double)pos.method_10263() + 0.5);
            double dz = player.method_23321() - ((double)pos.method_10260() + 0.5);
            entity.tRot = (float)Math.atan2(dz, dx);
        } else {
            entity.tRot += 0.02f;
        }
        while (entity.rot >= (float)Math.PI) {
            entity.rot -= (float)Math.PI * 2;
        }
        while (entity.rot < (float)(-Math.PI)) {
            entity.rot += (float)Math.PI * 2;
        }
        while (entity.tRot >= (float)Math.PI) {
            entity.tRot -= (float)Math.PI * 2;
        }
        while (entity.tRot < (float)(-Math.PI)) {
            entity.tRot += (float)Math.PI * 2;
        }
        for (rotDiff = entity.tRot - entity.rot; rotDiff >= (float)Math.PI; rotDiff -= (float)Math.PI * 2) {
        }
        while (rotDiff < (float)(-Math.PI)) {
            rotDiff += (float)Math.PI * 2;
        }
        entity.rot += rotDiff * 0.4f;
    }

    public void sync() {
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public void method_5447(int slot, @NotNull class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.sync();
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        this.sync();
        return stack;
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        class_1799 stack = class_1262.method_5428(this.inventory, (int)slot);
        this.sync();
        return stack;
    }

    public boolean method_16914() {
        return false;
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) < 64.0;
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    public boolean method_5437(int slotNumber, @NotNull class_1799 itemstack) {
        if (itemstack == class_1799.field_8037) {
            return true;
        }
        this.method_5431();
        if (slotNumber >= 0 && slotNumber < 8) {
            if (!(itemstack.method_7909() instanceof SpellBookItem)) {
                return false;
            }
            class_1799 centreStack = this.method_5438(9);
            class_1792 class_17922 = centreStack.method_7909();
            if (class_17922 instanceof IWorkbenchItem) {
                IWorkbenchItem workbenchItem = (IWorkbenchItem)class_17922;
                int spellSlots = workbenchItem.getSpellSlotCount(centreStack);
                return slotNumber < spellSlots;
            }
            return false;
        }
        if (slotNumber == 8) {
            return itemstack.method_7909() instanceof CrystalItem;
        }
        if (slotNumber == 9) {
            return itemstack.method_7909() instanceof IWorkbenchItem;
        }
        if (slotNumber == 10) {
            HashSet<class_1792> upgrades = new HashSet<class_1792>(WandUpgrades.getSpecialUpgrades());
            upgrades.add(EBItems.ARCANE_TOME.get());
            upgrades.add(EBItems.RESPLENDENT_THREAD.get());
            upgrades.add(EBItems.CRYSTAL_SILVER_PLATING.get());
            upgrades.add(EBItems.ETHEREAL_CRYSTAL_WEAVE.get());
            return upgrades.contains(itemstack.method_7909());
        }
        return true;
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        if (this.inventory == null) {
            this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        this.inventory.clear();
        class_1262.method_5429((class_2487)tag, this.inventory);
    }

    public void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.inventory);
    }

    @NotNull
    protected class_1703 method_5465(int containerId, @NotNull class_1661 inventory) {
        return new ArcaneWorkbenchMenu(containerId, inventory, (class_1263)this);
    }

    public void method_5448() {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.method_5447(i, class_1799.field_8037);
        }
        this.method_5431();
    }

    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.%s.arcane_workbench".formatted("ebwizardry"));
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

