/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.blockentity;

import com.binaris.wizardry.api.content.item.IElementValue;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.blockentity.ReceptacleBlockEntity;
import com.binaris.wizardry.content.recipe.ImbuementAltarRecipe;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBBlockEntities;
import com.binaris.wizardry.setup.registries.EBRecipeTypes;
import com.binaris.wizardry.setup.registries.EBSounds;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImbuementAltarBlockEntity
extends class_2586 {
    private static final int IMBUEMENT_DURATION = 140;
    private class_1799 stack = class_1799.field_8037;
    private int imbuementTimer;
    private class_1657 lastUser;
    private UUID lastUserUUID;
    @Nullable
    private Element element;

    public ImbuementAltarBlockEntity(class_2338 pos, class_2680 blockState) {
        super(EBBlockEntities.IMBUEMENT_ALTAR.get(), pos, blockState);
    }

    public static <T extends class_2586> void update(class_1937 level, class_2338 pos, class_2680 state, T entity) {
        if (!(entity instanceof ImbuementAltarBlockEntity)) {
            return;
        }
        ImbuementAltarBlockEntity altar = (ImbuementAltarBlockEntity)entity;
        if (altar.getLastUserUUID() != null && altar.getLastUser() == null) {
            altar.lastUser = level.method_18470(altar.lastUserUUID);
        }
        if (altar.imbuementTimer <= 0) {
            return;
        }
        if (altar.imbuementTimer == 1) {
            level.method_8396(altar.lastUser, pos, EBSounds.BLOCK_IMBUEMENT_ALTAR_IMBUE.get(), class_3419.field_15245, 1.0f, 1.0f);
        }
        if (altar.imbuementTimer++ >= 140) {
            altar.craftRecipe();
            class_1657 class_16572 = altar.lastUser;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                EBAdvancementTriggers.IMBUEMENT_ALTAR.trigger(serverPlayer, altar.stack);
            }
        }
    }

    private static class_1799[] getReceptacleItems(class_1937 level, class_2338 pos) {
        class_1799[] items = new class_1799[4];
        for (int i = 0; i < 4; ++i) {
            class_2586 te = level.method_8321(pos.method_10093(BlockUtil.getHorizontals()[i]));
            if (te instanceof ReceptacleBlockEntity) {
                ReceptacleBlockEntity e = (ReceptacleBlockEntity)te;
                items[i] = e.getStack();
                continue;
            }
            items[i] = null;
        }
        return items;
    }

    public void checkRecipe() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (this.stack.method_7960()) {
            this.imbuementTimer = 0;
            return;
        }
        class_1799[] receptacleItems = ImbuementAltarBlockEntity.getReceptacleItems(this.field_11863, this.field_11867);
        if (Arrays.stream(receptacleItems).anyMatch(Objects::isNull)) {
            this.imbuementTimer = 0;
            return;
        }
        ImbuementAltarRecipe recipe = this.field_11863.method_8433().method_30027(EBRecipeTypes.IMBUEMENT_ALTAR).stream().filter(r -> r instanceof ImbuementAltarRecipe).filter(r -> r.matches(this.stack, receptacleItems)).findFirst().orElse(null);
        if (recipe != null && this.imbuementTimer == 0) {
            this.imbuementTimer = 1;
            this.selectElement();
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        } else if (recipe == null) {
            this.imbuementTimer = 0;
        }
    }

    private void craftRecipe() {
        if (this.field_11863 == null) {
            return;
        }
        class_1799[] receptacleItems = ImbuementAltarBlockEntity.getReceptacleItems(this.field_11863, this.field_11867);
        if (Arrays.stream(receptacleItems).anyMatch(Objects::isNull)) {
            this.imbuementTimer = 0;
            return;
        }
        ImbuementAltarRecipe recipe = this.field_11863.method_8433().method_30027(EBRecipeTypes.IMBUEMENT_ALTAR).stream().filter(r -> r instanceof ImbuementAltarRecipe).filter(r -> r.matches(this.stack, receptacleItems)).findFirst().orElse(null);
        if (recipe != null) {
            int i;
            class_1799 result = recipe.method_8110(this.field_11863.method_30349()).method_7972();
            this.stack.method_7934(1);
            for (i = 0; i < 4; ++i) {
                receptacleItems[i].method_7934(1);
            }
            for (i = 0; i < 4; ++i) {
                class_2586 entity = this.field_11863.method_8321(this.field_11867.method_10093(BlockUtil.getHorizontals()[i]));
                if (!(entity instanceof ReceptacleBlockEntity)) continue;
                ReceptacleBlockEntity e = (ReceptacleBlockEntity)entity;
                e.setStack(class_1799.field_8037);
                this.field_11863.method_8413(e.method_11016(), e.method_11010(), e.method_11010(), 3);
            }
            this.setStack(result, false);
            this.field_11863.method_8486((double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5, EBSounds.BLOCK_IMBUEMENT_ALTAR_IMBUE.get(), class_3419.field_15245, 1.0f, 1.0f, false);
        }
        this.imbuementTimer = 0;
        this.method_5431();
    }

    private void selectElement() {
        if (this.field_11863 == null) {
            return;
        }
        class_1799[] receptacleItems = ImbuementAltarBlockEntity.getReceptacleItems(this.field_11863, this.field_11867);
        if (Arrays.stream(receptacleItems).anyMatch(Objects::isNull)) {
            this.element = null;
            return;
        }
        class_1799 item = receptacleItems[this.field_11863.field_9229.method_43048(receptacleItems.length)];
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof IElementValue) {
            IElementValue receptacleItem = (IElementValue)class_17922;
            this.element = receptacleItem.getElement();
        }
    }

    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        class_2487 itemTag = new class_2487();
        this.stack.method_7953(itemTag);
        nbt.method_10566("item", (class_2520)itemTag);
        nbt.method_10569("imbuementTimer", this.imbuementTimer);
        if (this.element != null) {
            nbt.method_10582("element", Services.REGISTRY_UTIL.getElement(this.element).toString());
        }
        if (this.lastUser != null) {
            nbt.method_25927("lastUser", this.lastUser.method_5667());
        }
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_2487 itemTag = nbt.method_10562("item");
        this.stack = class_1799.method_7915((class_2487)itemTag);
        this.imbuementTimer = nbt.method_10550("imbuementTimer");
        if (nbt.method_10545("element")) {
            this.element = Services.REGISTRY_UTIL.getElement(class_2960.method_12829((String)nbt.method_10558("element")));
        }
        if (nbt.method_25928("lastUser")) {
            this.lastUserUUID = nbt.method_25926("lastUser");
        }
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public float getImbuementProgress() {
        return (float)this.imbuementTimer / 140.0f;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public class_1657 getLastUser() {
        return this.lastUser;
    }

    public void setLastUser(class_1657 player) {
        this.lastUser = player;
        if (player != null) {
            this.lastUserUUID = player.method_5667();
        }
    }

    public UUID getLastUserUUID() {
        return this.lastUserUUID;
    }

    @Nullable
    public Element getElement() {
        return this.element;
    }

    public void setStack(class_1799 stack, boolean shouldCheckRecipe) {
        this.stack = stack;
        if (shouldCheckRecipe) {
            this.checkRecipe();
        }
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }
}

