/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.blockentity;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.ArcaneLockData;
import com.binaris.wizardry.api.content.data.ContainmentData;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.block.RunestonePedestalBlock;
import com.binaris.wizardry.content.entity.living.EvilWizard;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.core.mixin.accessor.RCBEAccessor;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBBlockEntities;
import com.binaris.wizardry.setup.registries.EBLootTables;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunestonePedestalBlockEntity
extends class_2586 {
    private static final double ACTIVATION_RADIUS = 7.0;
    private static final int WIZARD_SPAWN_COUNT = 3;
    private static final int WIZARD_SPAWN_RADIUS = 5;
    private static final int REGENERATION_DELAY_TICKS = 72000;
    private final List<UUID> spawnedWizards = new ArrayList<UUID>();
    private final List<UUID> playersInContainment = new ArrayList<UUID>();
    @Nullable
    private class_2338 linkedPos;
    private boolean natural;
    private boolean activated;
    private boolean conquered;
    private long regenerationTime;

    public RunestonePedestalBlockEntity(class_2338 pos, class_2680 blockState) {
        super(EBBlockEntities.RUNESTONE_PEDESTAL.get(), pos, blockState);
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 state, T entity) {
        RunestonePedestalBlockEntity pedestal;
        block11: {
            block10: {
                if (!(entity instanceof RunestonePedestalBlockEntity)) break block10;
                pedestal = (RunestonePedestalBlockEntity)entity;
                if (level != null && !level.field_9236) break block11;
            }
            return;
        }
        if (pedestal.conquered && EBConfig.shrineRegenerationEnabled && pedestal.regenerationTime > 0L && level.method_8510() >= pedestal.regenerationTime) {
            RunestonePedestalBlockEntity.regenerate(pedestal, pos);
            return;
        }
        if (!pedestal.natural) {
            level.method_8544(pos);
            return;
        }
        if (pedestal.linkedPos == null) {
            pedestal.tryLinkContainer(pos);
            if (!pedestal.natural) {
                return;
            }
        }
        long gameTime = level.method_8510();
        if (!pedestal.activated && gameTime % 20L == 0L) {
            pedestal.checkEvent(pos);
        }
        if (pedestal.activated) {
            pedestal.containmentEffect();
        }
        if (pedestal.activated && !pedestal.playersInContainment.isEmpty()) {
            pedestal.checkWizardsAlive();
        }
    }

    private static void regenerate(RunestonePedestalBlockEntity pedestal, class_2338 pos) {
        pedestal.natural = true;
        pedestal.activated = false;
        pedestal.conquered = false;
        class_2338 chestPos = pos.method_10084();
        class_2586 blockEntity = pedestal.field_11863.method_8321(chestPos);
        if (!(blockEntity instanceof class_2621)) {
            pedestal.field_11863.method_22352(chestPos, false);
            pedestal.field_11863.method_8501(chestPos, class_2246.field_10034.method_9564());
            RunestonePedestalBlockEntity.regenerate(pedestal, pos);
            return;
        }
        class_2621 container = (class_2621)blockEntity;
        container.method_11285(EBLootTables.SHRINE, pedestal.field_11863.method_8409().method_43055());
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((class_2586)container);
        if (data != null) {
            data.setArcaneLockOwner(UUID.randomUUID().toString());
        }
        pedestal.sync();
    }

    private void tryLinkContainer(class_2338 pos) {
        class_2621 container;
        class_2586 blockEntity = this.field_11863.method_8321(pos.method_10084());
        if (!(blockEntity instanceof class_2621) || ((RCBEAccessor)(container = (class_2621)blockEntity)).getLootTable() == null) {
            EBLogger.warn("Runestone Pedestal at {} is marked as natural but has no valid container block entity above it, check the structure and try to have a container block above it", pos);
            this.setNatural(false);
            return;
        }
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((class_2586)container);
        if (data != null) {
            data.setArcaneLockOwner(UUID.randomUUID().toString());
        }
        this.setLinkedPos(pos.method_10084());
    }

    private void checkEvent(class_2338 pos) {
        List nearbyPlayers = this.field_11863.method_18467(class_1657.class, new class_238(pos).method_1014(7.0));
        nearbyPlayers.removeIf(player -> player.method_7325() || !player.method_5805());
        if (nearbyPlayers.isEmpty()) {
            return;
        }
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 0.5;
        double z = (double)pos.method_10260() + 0.5;
        ParticleBuilder.create(EBParticles.SPHERE).pos(x, y + 1.0, z).color(15754389).scale(5.0f).time(12).allowServer(true).spawn(this.field_11863);
        this.field_11863.method_43128(null, x, y, z, EBSounds.BLOCK_PEDESTAL_ACTIVATE.get(), class_3419.field_15245, 1.5f, 1.0f);
        this.activated = true;
        this.spawnedWizards.clear();
        this.playersInContainment.addAll(nearbyPlayers.stream().map(class_1297::method_5667).toList());
        this.containmentEffect();
        this.spawnEvilWizards();
        this.sync();
    }

    private void spawnEvilWizards() {
        if (this.field_11863.field_9236) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            Element element;
            EvilWizard wizard = new EvilWizard(this.field_11863);
            class_2338 spawnPos = this.findSpawnPositionWizard(this.field_11863.field_9229.method_43057() * 2.0f * (float)Math.PI);
            wizard.method_5814((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            class_2248 class_22482 = this.method_11010().method_26204();
            if (class_22482 instanceof RunestonePedestalBlock) {
                RunestonePedestalBlock runestone = (RunestonePedestalBlock)class_22482;
                element = runestone.getElement();
            } else {
                element = Elements.FIRE;
            }
            wizard.setElement(element);
            wizard.method_5943((class_5425)this.field_11863, this.field_11863.method_8404(this.method_11016()), class_3730.field_16474, null, null);
            this.field_11863.method_8649((class_1297)wizard);
            this.spawnedWizards.add(wizard.method_5667());
        }
    }

    private void containmentEffect() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        this.playersInContainment.removeIf(uuid -> {
            class_1657 player = serverLevel.method_18470(uuid);
            if (player == null || !player.method_5805()) {
                return true;
            }
            this.setContainmentPos((class_1309)player);
            player.method_6092(new class_1293(EBMobEffects.CONTAINMENT.get(), 200, 0, false, false, true));
            return false;
        });
        this.spawnedWizards.removeIf(uuid -> {
            class_1297 entity = serverLevel.method_14190(uuid);
            if (entity == null || !entity.method_5805()) {
                return true;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                this.setContainmentPos(livingEntity);
                livingEntity.method_6092(new class_1293(EBMobEffects.CONTAINMENT.get(), 200, 0, false, false, true));
            }
            return false;
        });
    }

    private void checkWizardsAlive() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        this.spawnedWizards.removeIf(uuid -> {
            class_1297 entity = serverLevel.method_14190(uuid);
            return entity == null || !entity.method_5805();
        });
        if (this.spawnedWizards.isEmpty()) {
            boolean playersEmpty = this.playersInContainment.isEmpty();
            this.conquered();
            if (playersEmpty) {
                RunestonePedestalBlockEntity.regenerate(this, this.method_11016());
            }
        }
    }

    private void conquered() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        serverLevel.method_8396(null, this.method_11016(), EBSounds.BLOCK_PEDESTAL_CONQUER.get(), class_3419.field_15245, 1.5f, 1.0f);
        this.playersInContainment.forEach(uuid -> {
            class_1657 player = serverLevel.method_18470(uuid);
            if (player != null) {
                player.method_6016(EBMobEffects.CONTAINMENT.get());
            }
        });
        this.playersInContainment.clear();
        this.spawnConqueredParticles();
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData(this.field_11863.method_8321(this.linkedPos));
        if (data != null) {
            data.clearArcaneLockOwner();
        }
        this.conquered = true;
        this.regenerationTime = this.field_11863.method_8510() + 72000L;
        this.sync();
    }

    private void spawnConqueredParticles() {
        double x = (double)this.method_11016().method_10263() + 0.5;
        double y = (double)this.method_11016().method_10264() + 0.5;
        double z = (double)this.method_11016().method_10260() + 0.5;
        ParticleBuilder.create(EBParticles.SPHERE).scale(5.0f).pos(x, y + 1.0, z).color(15754389).time(12).allowServer(true).spawn(this.field_11863);
        for (int i = 0; i < 5; ++i) {
            float brightness = 0.8f + this.field_11863.field_9229.method_43057() * 0.2f;
            ParticleBuilder.create(EBParticles.SPARKLE, this.field_11863.field_9229, x, y + 1.0, z, 1.0, true).color(1.0f, brightness, brightness).allowServer(true).spawn(this.field_11863);
        }
    }

    private class_2338 findSpawnPositionWizard(float angle) {
        int x = (int)((double)this.method_11016().method_10263() + 0.5 + (double)(5.0f * class_3532.method_15374((float)angle)));
        int z = (int)((double)this.method_11016().method_10260() + 0.5 + (double)(5.0f * class_3532.method_15362((float)angle)));
        Integer y = BlockUtil.getNearestFloor(this.field_11863, new class_2338(x, this.method_11016().method_10264(), z), 8);
        return y != null ? new class_2338(x, y.intValue(), z) : this.method_11016().method_10069(1, 0, 0);
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        if (this.linkedPos != null) {
            tag.method_10566("LinkedPos", (class_2520)class_2512.method_10692((class_2338)this.linkedPos));
        }
        tag.method_10556("Natural", this.natural);
        tag.method_10556("Activated", this.activated);
        tag.method_10556("Conquered", this.conquered);
        tag.method_10544("RegenerationTime", this.regenerationTime);
        this.saveUUIDList(tag, "SpawnedWizards", this.spawnedWizards);
        this.saveUUIDList(tag, "PlayersInContainment", this.playersInContainment);
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.linkedPos = tag.method_10545("LinkedPos") ? class_2512.method_10691((class_2487)tag.method_10562("LinkedPos")) : null;
        this.natural = tag.method_10577("Natural");
        this.activated = tag.method_10577("Activated");
        this.conquered = tag.method_10577("Conquered");
        this.regenerationTime = tag.method_10537("RegenerationTime");
        this.loadUUIDList(tag, "SpawnedWizards", this.spawnedWizards);
        this.loadUUIDList(tag, "PlayersInContainment", this.playersInContainment);
    }

    private void saveUUIDList(class_2487 tag, String key, List<UUID> list) {
        if (list.isEmpty()) {
            return;
        }
        class_2499 listTag = new class_2499();
        for (UUID uuid : list) {
            class_2487 uuidTag = new class_2487();
            uuidTag.method_25927("UUID", uuid);
            listTag.add((Object)uuidTag);
        }
        tag.method_10566(key, (class_2520)listTag);
    }

    private void loadUUIDList(class_2487 tag, String key, List<UUID> list) {
        list.clear();
        if (!tag.method_10545(key)) {
            return;
        }
        class_2499 listTag = tag.method_10554(key, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            list.add(listTag.method_10602(i).method_25926("UUID"));
        }
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    private void setContainmentPos(class_1309 entity) {
        ContainmentData data = Services.OBJECT_DATA.getContainmentData(entity);
        data.setContainmentPos(this.field_11867);
    }

    private void sync() {
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void setLinkedPos(@Nullable class_2338 pos) {
        this.linkedPos = pos;
        this.sync();
    }

    public boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
        this.sync();
    }
}

