/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command;

import com.binaris.wizardry.api.content.data.CastCommandData;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.content.command.argument.SpellArgument;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class CastCommand {
    public static final int DEFAULT_CASTING_DURATION = 400;

    private CastCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cast").requires(p -> p.method_9259(2))).then(class_2170.method_9244((String)"spell", (ArgumentType)SpellArgument.spell()).executes(context -> CastCommand.executePlayer((CommandContext<class_2168>)context, SpellArgument.getSpell((CommandContext<class_2168>)context, "spell")))));
    }

    private static int executePlayer(CommandContext<class_2168> context, Spell spell) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.ebwizardry.cast.player_only"));
            return 0;
        }
        if (spell == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.ebwizardry.cast.unknown_spell"));
            return 0;
        }
        class_3222 player = source.method_44023();
        SpellModifiers modifiers = new SpellModifiers();
        if (WizardryEventBus.getInstance().fire(new SpellCastEvent.Pre(SpellCastEvent.Source.COMMAND, spell, (class_1309)player, modifiers))) {
            source.method_9213((class_2561)class_2561.method_43471((String)("commands.ebwizardry.cast.failure" + spell.getDescriptionId())));
            return 0;
        }
        if (!spell.isInstantCast()) {
            return CastCommand.handleContinuousSpell(source, spell, player, modifiers);
        }
        return CastCommand.handleInstantSpell(source, spell, player, modifiers);
    }

    private static int handleContinuousSpell(class_2168 source, Spell spell, class_3222 player, SpellModifiers modifiers) {
        CastCommandData data = Services.OBJECT_DATA.getCastCommandData((class_1657)player);
        if (data.isCommandCasting()) {
            data.stopCastingContinuousSpell();
        } else {
            data.startCastingContinuousSpell(spell, modifiers, 400);
            source.method_45068((class_2561)class_2561.method_43469((String)"commands.ebwizardry.cast.success_continuous", (Object[])new Object[]{spell.getDescriptionId()}));
        }
        return 1;
    }

    private static int handleInstantSpell(class_2168 source, Spell spell, class_3222 player, SpellModifiers modifiers) {
        if (spell.cast(new PlayerCastContext(player.method_37908(), (class_1657)player, class_1268.field_5808, 0, modifiers))) {
            WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, spell, (class_1309)player, modifiers));
            source.method_45068((class_2561)class_2561.method_43469((String)"commands.ebwizardry.cast.success", (Object[])new Object[]{spell.getDescriptionFormatted()}));
        }
        return 0;
    }
}

