/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.core.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public final class SpellContextCommand {
    private static final SuggestionProvider<class_2168> CONTEXT_SUGGESTIONS = (context, builder) -> class_2172.method_9253((String[])SpellContext.getAllKeys(), (SuggestionsBuilder)builder);

    private SpellContextCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spellContext").requires(p -> p.method_9259(2))).then(class_2170.method_9244((String)"context", (ArgumentType)StringArgumentType.word()).suggests(CONTEXT_SUGGESTIONS).executes(c -> SpellContextCommand.listSpellsByContext((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"context")))));
    }

    private static int listSpellsByContext(class_2168 source, String context) {
        if (!SpellContext.isValidKey(context)) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Invalid context: " + context)).method_27692(class_124.field_1061));
            source.method_45068((class_2561)class_2561.method_43470((String)("Valid contexts: " + String.join((CharSequence)", ", SpellContext.getAllKeys()))).method_27692(class_124.field_1080));
            return 0;
        }
        SpellContext spellContext = SpellContext.fromKey(context);
        List<Spell> enabledSpells = Services.REGISTRY_UTIL.getSpells().stream().filter(spell -> spell.isEnabled(spellContext)).toList();
        List<Spell> disabledSpells = Services.REGISTRY_UTIL.getSpells().stream().filter(spell -> !spell.isEnabled(spellContext)).toList();
        source.method_45068((class_2561)class_2561.method_43470((String)"=".repeat(50)).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        source.method_45068((class_2561)class_2561.method_43470((String)"Spells for context: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)context).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})));
        source.method_45068((class_2561)class_2561.method_43470((String)"=".repeat(50)).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        source.method_45068((class_2561)class_2561.method_43470((String)("\n\u2713 ENABLED (" + enabledSpells.size() + ")")).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
        if (enabledSpells.isEmpty()) {
            source.method_45068((class_2561)class_2561.method_43470((String)"  No enabled spells").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        } else {
            for (Spell spell2 : enabledSpells) {
                source.method_45068((class_2561)class_2561.method_43470((String)"  \u2022 ").method_27692(class_124.field_1060).method_10852(spell2.getDescriptionFormatted()).method_10852((class_2561)class_2561.method_43470((String)(" [" + String.valueOf(spell2.getLocation()) + "]")).method_27692(class_124.field_1080)));
            }
        }
        source.method_45068((class_2561)class_2561.method_43470((String)("\n\u2717 DISABLED (" + disabledSpells.size() + ")")).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        if (disabledSpells.isEmpty()) {
            source.method_45068((class_2561)class_2561.method_43470((String)"  No disabled spells").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        } else {
            for (Spell spell2 : disabledSpells) {
                source.method_45068((class_2561)class_2561.method_43470((String)"  \u2022 ").method_27692(class_124.field_1061).method_10852(spell2.getDescriptionFormatted()).method_10852((class_2561)class_2561.method_43470((String)(" [" + String.valueOf(spell2.getLocation()) + "]")).method_27692(class_124.field_1080)));
            }
        }
        source.method_45068((class_2561)class_2561.method_43470((String)"=".repeat(50)).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        return 1;
    }
}

