/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command.debug;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.item.WandItem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class WandSelectCommand {
    private static final SuggestionProvider<class_2168> MODE_SUGGESTIONS = (context, builder) -> class_2172.method_9265(Arrays.asList("next", "previous"), (SuggestionsBuilder)builder);

    private WandSelectCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wandselect").then(class_2170.method_9247((String)"mode").then(class_2170.method_9244((String)"option", (ArgumentType)StringArgumentType.word()).suggests(MODE_SUGGESTIONS).executes(ctx -> WandSelectCommand.executeMode((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"option")))))).then(class_2170.method_9247((String)"index").then(class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> WandSelectCommand.executeIndex((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot"))))));
    }

    private static int executeMode(CommandContext<class_2168> context, String option) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You need to be a player to execute this!"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_1799 wandStack = player.method_6047();
        if (!(wandStack.method_7909() instanceof WandItem)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be holding a wand!"));
            return 0;
        }
        Spell newSelected = option.equalsIgnoreCase("previous") ? WandHelper.getPreviousSpell(wandStack) : (option.equalsIgnoreCase("next") ? WandHelper.getNextSpell(wandStack) : WandHelper.getCurrentSpell(wandStack));
        WandHelper.setCurrentSpell(wandStack, newSelected);
        source.method_45068((class_2561)class_2561.method_43470((String)("Spell selected: " + newSelected.getDescriptionId())));
        return 1;
    }

    private static int executeIndex(CommandContext<class_2168> context, int slot) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You need to be a player to execute this!"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_1799 wandStack = player.method_6047();
        class_1792 class_17922 = wandStack.method_7909();
        if (!(class_17922 instanceof WandItem)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be holding a wand!"));
            return 0;
        }
        WandItem wandItem = (WandItem)class_17922;
        int maxSlots = wandItem.getSpellSlotCount(wandStack);
        if (slot < 0 || slot >= maxSlots) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Invalid slot number. Must be between 0 and " + (maxSlots - 1))));
            return 0;
        }
        List<Spell> spells = WandHelper.getSpells(wandStack);
        Spell newSelected = spells.get(slot);
        WandHelper.setCurrentSpell(wandStack, newSelected);
        source.method_45068((class_2561)class_2561.method_43470((String)("Spell selected: " + newSelected.getDescriptionId() + " at " + slot)));
        return 1;
    }
}

