/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.data;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.event.EBServerLevelLoadEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.NBTExtras;
import com.binaris.wizardry.core.networking.s2c.SpellGlyphPacketS2C;
import com.binaris.wizardry.core.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;

public class SpellGlyphData
extends class_18 {
    private static final String NAME = "ebwizardry_glyphData";
    public Map<Spell, String> randomNames = new HashMap<Spell, String>();
    public Map<Spell, String> randomDescriptions = new HashMap<Spell, String>();

    public static SpellGlyphData get(class_3218 world) {
        SpellGlyphData instance = (SpellGlyphData)world.method_17983().method_20786(SpellGlyphData::load, NAME);
        if (instance == null) {
            instance = new SpellGlyphData();
        }
        boolean changed = false;
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            if (!instance.randomNames.containsKey(spell)) {
                instance.randomNames.put(spell, instance.generateRandomName(world.field_9229));
                changed = true;
            }
            if (instance.randomDescriptions.containsKey(spell)) continue;
            instance.randomDescriptions.put(spell, instance.generateRandomDescription(world.field_9229));
            changed = true;
        }
        if (changed) {
            instance.method_80();
            world.method_17983().method_123(NAME, (class_18)instance);
        }
        return instance;
    }

    public static class_2561 getGlyphNameFormatted(Spell spell, SpellGlyphData data) {
        return class_2561.method_43470((String)SpellGlyphData.getGlyphName(spell, data)).method_27696(class_2583.field_24360.method_27704(new class_2960("minecraft", "alt")));
    }

    public static String getGlyphName(Spell spell, SpellGlyphData data) {
        Map<Spell, String> names = data.randomNames;
        return names == null ? "" : names.getOrDefault(spell, "");
    }

    public static String getGlyphDescription(Spell spell, SpellGlyphData data) {
        Map<Spell, String> descriptions = data.randomDescriptions;
        return descriptions == null ? "" : descriptions.getOrDefault(spell, "");
    }

    public static String getGlyphName(Spell spell, class_3218 world) {
        Map<Spell, String> names = SpellGlyphData.get((class_3218)world).randomNames;
        return names == null ? "" : names.getOrDefault(spell, "");
    }

    public static String getGlyphDescription(Spell spell, class_3218 world) {
        Map<Spell, String> descriptions = SpellGlyphData.get((class_3218)world).randomDescriptions;
        return descriptions == null ? "" : descriptions.getOrDefault(spell, "");
    }

    public static SpellGlyphData load(class_2487 nbt) {
        SpellGlyphData data = new SpellGlyphData();
        data.randomNames = new HashMap<Spell, String>();
        data.randomDescriptions = new HashMap<Spell, String>();
        class_2499 tagList = nbt.method_10554("spellGlyphData", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 tag = tagList.method_10602(i);
            String spellStr = tag.method_10558("spell");
            class_2960 loc = class_2960.method_12829((String)spellStr);
            if (loc == null) {
                EBLogger.warn("Skipping malformed spell entry in glyph data: " + spellStr, new Object[0]);
                continue;
            }
            Spell spell = Services.REGISTRY_UTIL.getSpell(loc);
            if (spell == null) {
                EBLogger.info("Skipping unknown spell in glyph data: " + String.valueOf(loc), new Object[0]);
                continue;
            }
            data.randomNames.put(spell, tag.method_10558("name"));
            data.randomDescriptions.put(spell, tag.method_10558("description"));
        }
        return data;
    }

    public static void onServerLevelLoad(EBServerLevelLoadEvent event) {
        if (event.getLevel().field_9236) {
            return;
        }
        class_3218 level = (class_3218)event.getLevel();
        if (level.method_27983().method_29177().method_12832().equals("overworld")) {
            SpellGlyphData.get(level);
        }
    }

    public void generateGlyphNames(class_1937 world) {
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            if (!this.randomNames.containsKey(spell)) {
                this.randomNames.put(spell, this.generateRandomName(world.field_9229));
            }
            if (this.randomDescriptions.containsKey(spell)) continue;
            this.randomDescriptions.put(spell, this.generateRandomDescription(world.field_9229));
        }
        this.method_80();
    }

    private String generateRandomName(class_5819 random) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < random.method_43048(2) + 2; ++i) {
            name.append(RandomStringUtils.random((int)(3 + random.method_43048(5)), (String)"abcdefghijklmnopqrstuvwxyz")).append(" ");
        }
        return name.toString().trim();
    }

    private String generateRandomDescription(class_5819 random) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < random.method_43048(16) + 8; ++i) {
            name.append(RandomStringUtils.random((int)(2 + random.method_43048(7)), (String)"abcdefghijklmnopqrstuvwxyz")).append(" ");
        }
        return name.toString().trim();
    }

    public void sync(class_3222 player) {
        HashMap<class_2960, String> names = new HashMap<class_2960, String>();
        HashMap<class_2960, String> descriptions = new HashMap<class_2960, String>();
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            names.put(spell.getLocation(), this.randomNames.get(spell));
            descriptions.put(spell.getLocation(), this.randomDescriptions.get(spell));
        }
        SpellGlyphPacketS2C msg = new SpellGlyphPacketS2C(names, descriptions);
        Services.NETWORK_HELPER.sendTo(player, msg);
        EBLogger.info("Synchronising spell glyph data for " + player.method_5477().getString(), new Object[0]);
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 nbt) {
        class_2499 tagList = new class_2499();
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            class_2487 tag = new class_2487();
            tag.method_10582("spell", spell.getLocation().toString());
            if (this.randomNames.get(spell) != null) {
                tag.method_10582("name", this.randomNames.get(spell));
            }
            if (this.randomDescriptions.get(spell) != null) {
                tag.method_10582("description", this.randomDescriptions.get(spell));
            }
            tagList.add((Object)tag);
        }
        NBTExtras.storeTagSafely(nbt, "spellGlyphData", (class_2520)tagList);
        return nbt;
    }
}

