/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;

public class BlizzardConstruct
extends ScaledConstructEntity {
    public BlizzardConstruct(class_1299<?> type, class_1937 level) {
        super(type, level);
        this.lifetime = Spells.BLIZZARD.property(DefaultProperties.DURATION);
    }

    public BlizzardConstruct(class_1937 world) {
        super(EBEntities.BLIZZARD.get(), world);
        this.lifetime = Spells.BLIZZARD.property(DefaultProperties.DURATION);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.field_6012 % 120 == 1) {
            this.method_5783(EBSounds.ENTITY_BLIZZARD_AMBIENT.get(), 1.0f, 1.0f);
        }
        double radius = (float)Spells.BLIZZARD.property(DefaultProperties.EFFECT_RADIUS).intValue() * this.sizeMultiplier;
        if (!this.method_37908().field_9236) {
            List<class_1309> targets = EntityUtil.getLivingWithinRadius(radius, this.method_23317(), this.method_23318(), this.method_23321(), this.method_37908());
            for (class_1309 target : targets) {
                if (this.isValidTarget((class_1297)target)) {
                    EntityUtil.attackEntityWithoutKnockback((class_1297)target, this.getCaster() != null ? MagicDamageSource.causeIndirectMagicDamage(this, (class_1297)this.getCaster(), EBDamageSources.FROST) : MagicDamageSource.causeDirectMagicDamage(this, EBDamageSources.SORCERY), 1.0f * this.damageMultiplier);
                }
                target.method_6092(new class_1293(EBMobEffects.FROST.get(), 20));
            }
        } else {
            double speed;
            int i;
            for (i = 0; i < 6; ++i) {
                speed = (double)(this.field_5974.method_43056() ? 1 : -1) * (0.1 + 0.05 * this.field_5974.method_43058());
                ParticleBuilder.create(EBParticles.SNOW).pos(this.method_23317(), this.method_23318() + this.field_5974.method_43058() * (double)this.method_17682(), this.method_23321()).velocity(0.0, 0.0, 0.0).time(100).scale(2.0f).spin(this.field_5974.method_43058() * (radius - 0.5) + 0.5, speed).shaded(true).spawn(this.method_37908());
            }
            for (i = 0; i < 3; ++i) {
                speed = (double)(this.field_5974.method_43056() ? 1 : -1) * (0.05 + 0.02 * this.field_5974.method_43058());
                ParticleBuilder.create(EBParticles.CLOUD).pos(this.method_23317(), this.method_23318() + this.field_5974.method_43058() * ((double)this.method_17682() - 0.5), this.method_23321()).color(0xFFFFFF).shaded(true).spin(this.field_5974.method_43058() * (radius - 1.0) + 0.5, speed).spawn(this.method_37908());
            }
        }
    }

    @Override
    @NotNull
    public class_4048 method_18377(@NotNull class_4050 pose) {
        return class_4048.method_18384((float)(Spells.BLIZZARD.property(DefaultProperties.EFFECT_RADIUS) * 2), (float)3.0f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }
}

