/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.earth.Boulder;
import com.binaris.wizardry.core.ClientSpellSoundManager;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class BoulderConstruct
extends ScaledConstructEntity {
    private static final double AIR_FRICTION = 0.99;
    private static final double GROUND_FRICTION = 0.985;
    private boolean soundStarted = false;

    public BoulderConstruct(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_5960 = false;
        this.method_5875(false);
        this.lifetime = Spells.BOULDER.property(DefaultProperties.DURATION);
    }

    public BoulderConstruct(class_1937 world) {
        super(EBEntities.BOULDER.get(), world);
        this.field_5960 = false;
        this.method_5875(false);
        this.lifetime = Spells.BOULDER.property(DefaultProperties.DURATION);
    }

    public void setHorizontalVelocity(double velX, double velZ) {
        this.method_18800(velX, this.method_18798().field_1351, velZ);
    }

    @Override
    public void method_5773() {
        if (this.method_37908().field_9236 && !this.soundStarted && this.method_24828()) {
            this.soundStarted = true;
            ClientSpellSoundManager.playMovingSound(this, EBSounds.ENTITY_BOULDER_ROLL.get(), class_3419.field_15248, 1.0f, 1.0f, true);
        }
        super.method_5773();
        class_243 motion = this.method_18798();
        double newY = motion.field_1351 - 0.04;
        double friction = this.method_24828() ? 0.985 : 0.99;
        double newX = motion.field_1352 * friction;
        double newZ = motion.field_1350 * friction;
        this.method_18800(newX, newY, newZ);
        this.method_5784(class_1313.field_6308, this.method_18798());
        List collided = this.method_37908().method_18467(class_1309.class, this.method_5829());
        float damage = Spells.BOULDER.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
        float knockback = Spells.BOULDER.property(Boulder.KNOCKBACK_STRENGTH).floatValue();
        for (class_1309 entity : collided) {
            if (!this.isValidTarget((class_1297)entity)) continue;
            boolean crushBonus = entity.method_23318() < this.method_23318() && entity.method_5829().field_1323 > this.method_5829().field_1323 && entity.method_5829().field_1320 < this.method_5829().field_1320 && entity.method_5829().field_1321 > this.method_5829().field_1321 && entity.method_5829().field_1324 < this.method_5829().field_1324;
            if (EntityUtil.attackEntityWithoutKnockback((class_1297)entity, MagicDamageSource.causeIndirectMagicDamage(this, (class_1297)this.getCaster(), EBDamageSources.SORCERY), crushBonus ? damage * 1.5f : damage) && !crushBonus) {
                EntityUtil.applyStandardKnockback(this, entity, knockback);
                entity.method_18799(entity.method_18798().method_1031(motion.field_1352, 0.0, motion.field_1350));
            }
            entity.method_5783(EBSounds.ENTITY_BOULDER_HIT.get(), 1.0f, 1.0f);
        }
        if (this.field_5976) {
            this.shakeNearbyPlayers();
        }
        if (this.method_24828()) {
            for (int i = 0; i < 10; ++i) {
                double particleX = this.method_23317() + (double)this.method_17681() * 0.7 * (this.field_5974.method_43058() - 0.5);
                double particleZ = this.method_23321() + (double)this.method_17681() * 0.7 * (this.field_5974.method_43058() - 0.5);
                class_2680 block = this.method_37908().method_8320(this.method_24515().method_10074());
                if (block.method_26204() == class_2246.field_10124) continue;
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, block), particleX, this.method_23318(), particleZ, 0.0, 0.2, 0.0);
            }
        }
        if (this.method_24828() && motion.method_37267() < 0.005) {
            this.despawn();
        }
    }

    private void shakeNearbyPlayers() {
    }

    @Override
    public void despawn() {
        if (this.method_37908().field_9236) {
            for (int i = 0; i < 200; ++i) {
                double x = this.method_23317() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
                double y = this.method_23318() + this.field_5974.method_43058() * (double)this.method_17682();
                double z = this.method_23321() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10566.method_9564()), x, y, z, (x - this.method_23317()) * 0.1, (y - this.method_23318() + (double)(this.method_17682() / 2.0f)) * 0.1, (z - this.method_23321()) * 0.1);
            }
            this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), EBSounds.ENTITY_BOULDER_BREAK_BLOCK.get(), class_3419.field_15245, 1.0f, 1.0f, false);
        }
        super.despawn();
    }

    public void method_5784(@NotNull class_1313 type, @NotNull class_243 vec) {
        super.method_5784(type, vec);
        double distance = Math.sqrt(vec.field_1352 * vec.field_1352 + vec.field_1350 * vec.field_1350);
        this.method_36457((float)((double)this.method_36455() + Math.toDegrees(distance / (double)(this.method_17681() / 2.0f))));
    }

    public boolean method_5747(float distance, float damageMultiplier, @NotNull class_1282 source) {
        if (this.method_37908().field_9236) {
            for (int i = 0; i < 40; ++i) {
                double particleX = this.method_23317() - 1.5 + 3.0 * this.field_5974.method_43058();
                double particleZ = this.method_23321() - 1.5 + 3.0 * this.field_5974.method_43058();
                class_2680 block = this.method_37908().method_8320(this.method_24515().method_33096(this.method_24515().method_10264() - 2));
                if (block.method_26204() == class_2246.field_10124) continue;
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, block), particleX, this.method_23318(), particleZ, particleX - this.method_23317(), 0.0, particleZ - this.method_23321());
            }
            if ((double)distance > 1.2) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), EBSounds.ENTITY_BOULDER_LAND.get(), class_3419.field_15245, Math.min(2.0f, distance / 4.0f), 1.0f, false);
                this.shakeNearbyPlayers();
            }
        }
        return super.method_5747(distance, damageMultiplier, source);
    }

    @NotNull
    public class_238 method_5830() {
        return this.method_5829();
    }
}

