/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.client.particle.ParticleTornado;
import com.binaris.wizardry.core.ClientSpellSoundManager;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;

public class TornadoConstruct
extends ScaledConstructEntity {
    private double velX;
    private double velZ;

    public TornadoConstruct(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public TornadoConstruct(class_1937 world) {
        super(EBEntities.TORNADO.get(), world);
    }

    @Override
    @NotNull
    public class_4048 method_18377(@NotNull class_4050 pose) {
        return class_4048.method_18384((float)4.0f, (float)8.0f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }

    public void setHorizontalVelocity(double velX, double velZ) {
        this.velX = velX;
        this.velZ = velZ;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        double radius = this.method_17681() / 2.0f;
        if (this.field_6012 % 120 == 1 && this.method_37908().field_9236) {
            ClientSpellSoundManager.playMovingSound(this, EBSounds.ENTITY_TORNADO_AMBIENT.get(), class_3419.field_15251, 1.0f, 1.0f, false);
        }
        this.method_5784(class_1313.field_6308, new class_243(this.velX, this.method_18798().field_1351, this.velZ));
        class_2338 pos = this.method_24515();
        Integer y = BlockUtil.getNearestSurface(this.method_37908(), pos.method_10086(3), class_2350.field_11036, 5, true, BlockUtil.SurfaceCriteria.NOT_AIR_TO_AIR);
        if (y != null && this.method_37908().method_8320(pos.method_10086(y - pos.method_10264())).method_27852(class_2246.field_10164)) {
            this.method_5639(5);
        }
        if (!this.method_37908().field_9236) {
            List<class_1309> targets = EntityUtil.getLivingWithinRadius(radius, this.method_23317(), this.method_23318(), this.method_23321(), this.method_37908());
            for (class_1309 target : targets) {
                if (target instanceof class_1657 && this.getCaster() instanceof class_1657 || !this.isValidTarget((class_1297)target)) continue;
                this.applyTornadoEffects(target);
            }
        } else {
            this.spawnParticles();
        }
    }

    private void applyTornadoEffects(class_1309 target) {
        double velY = target.method_18798().field_1351;
        double dx = (this.method_23317() - target.method_23317() > 0.0 ? 0.5 : -0.5) - (this.method_23317() - target.method_23317()) * 0.125;
        double dz = (this.method_23321() - target.method_23321() > 0.0 ? 0.5 : -0.5) - (this.method_23321() - target.method_23321()) * 0.125;
        if (this.method_5809()) {
            target.method_5639(4);
        }
        float damage = 1.0f * this.damageMultiplier;
        MagicDamageSource.causeMagicDamage(this, (class_1297)target, damage, EBDamageSources.SORCERY);
        target.method_18800(dx, velY + 0.2, dz);
        if (target instanceof class_3222) {
            class_3222 sp = (class_3222)target;
            sp.field_13987.method_14364((class_2596)new class_2743((class_1297)target));
        }
    }

    private void spawnParticles() {
        for (int i = 1; i < 10; ++i) {
            double yPos = this.field_5974.method_43058() * 8.0;
            class_2338 pos = class_2338.method_49637((double)(this.method_23317() - 2.0 + (double)this.field_5974.method_43048(4)), (double)((int)(this.method_23318() + 3.0)), (double)(this.method_23321() - 2.0 + (double)this.field_5974.method_43048(4)));
            Integer blockY = BlockUtil.getNearestSurface(this.method_37908(), pos, class_2350.field_11036, 5, true, BlockUtil.SurfaceCriteria.NOT_AIR_TO_AIR);
            if (blockY == null) continue;
            class_2680 block = this.method_37908().method_8320(pos.method_10086(blockY - pos.method_10264()));
            ParticleTornado.spawnTornadoParticle(this.method_37908(), this.method_23317(), this.method_23318() + yPos, this.method_23321(), this.velX, this.velZ, yPos / 3.0 + 0.5, 100, block, pos);
            if (this.field_5974.method_43048(3) != 0) continue;
            this.spawnAdditionalParticles(block);
        }
    }

    private void spawnAdditionalParticles(class_2680 block) {
        DeferredObject<class_2400> type = null;
        if (block.method_26164(class_3481.field_15503)) {
            type = EBParticles.LEAF;
        }
        if (block.method_26164(class_3481.field_29823)) {
            type = EBParticles.SNOW;
        }
        if (type != null) {
            double yPos = this.field_5974.method_43058() * 8.0;
            ParticleBuilder.create(type).pos(this.method_23317() + (this.field_5974.method_43058() * 2.0 - 1.0) * (yPos / 3.0 + 0.5), this.method_23318() + yPos, this.method_23321() + (this.field_5974.method_43058() * 2.0 - 1.0) * (yPos / 3.0 + 0.5)).time(40 + this.field_5974.method_43048(10)).spawn(this.method_37908());
        }
    }

    @Override
    protected void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.velX = tag.method_10574("velX");
        this.velZ = tag.method_10574("velZ");
    }

    @Override
    protected void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10549("velX", this.velX);
        tag.method_10549("velZ", this.velZ);
    }
}

