/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.goal;

import com.binaris.wizardry.api.content.entity.living.ISpellCaster;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.content.entity.living.AbstractWizard;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.networking.s2c.NPCSpellCastS2C;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;

public class AttackSpellGoal<T extends class_1308>
extends class_1352 {
    private final T attacker;
    private final int baseCooldown;
    private final int continuousSpellDuration;
    private final double speed;
    private final float maxAttackDistance;
    private class_1309 target;
    private int cooldown = -1;
    private int continuousSpellTimer;
    private int seeTime;

    public AttackSpellGoal(T attacker, double speed, float maxDistance, int baseCooldown, int continuousSpellDuration) {
        this.attacker = attacker;
        this.baseCooldown = baseCooldown;
        this.continuousSpellDuration = continuousSpellDuration;
        this.speed = speed;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18408));
    }

    public boolean method_6264() {
        class_1309 livingEntity = this.attacker.method_5968();
        if (livingEntity == null) {
            return false;
        }
        this.target = livingEntity;
        return true;
    }

    public boolean method_6266() {
        return this.method_6264() || !this.attacker.method_5942().method_6357();
    }

    public void method_6270() {
        this.target = null;
        this.seeTime = 0;
        this.cooldown = -1;
        this.setContinuousSpellAndNotify(Spells.NONE, new SpellModifiers());
        this.continuousSpellTimer = 0;
    }

    private void setContinuousSpellAndNotify(Spell spell, SpellModifiers modifiers) {
        ((ISpellCaster)this.attacker).setContinuousSpell(spell);
        Services.NETWORK_HELPER.sendToTracking((class_1297)this.attacker, new NPCSpellCastS2C(this.attacker.method_5628(), this.target == null ? -1 : this.target.method_5628(), class_1268.field_5808, spell, modifiers));
    }

    public void method_6268() {
        double distanceSq = this.attacker.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
        boolean targetIsVisible = this.attacker.method_5985().method_6369((class_1297)this.target);
        this.seeTime = targetIsVisible ? ++this.seeTime : 0;
        if (distanceSq <= (double)this.maxAttackDistance && this.seeTime >= 5) {
            this.attacker.method_5942().method_6340();
        } else {
            this.attacker.method_5942().method_6335((class_1297)this.target, this.speed);
        }
        this.attacker.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
        if (this.continuousSpellTimer > 0) {
            --this.continuousSpellTimer;
            int currentTick = this.continuousSpellDuration - this.continuousSpellTimer;
            EntityCastContext ctx = new EntityCastContext(this.attacker.method_37908(), (class_1309)this.attacker, class_1268.field_5808, currentTick, this.target, ((ISpellCaster)this.attacker).getModifiers());
            ((ISpellCaster)this.attacker).setSpellCounter(currentTick);
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible || WizardryEventBus.getInstance().fire(new SpellCastEvent.Tick(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), (class_1309)this.attacker, ((ISpellCaster)this.attacker).getModifiers(), currentTick)) || !((ISpellCaster)this.attacker).getContinuousSpell().cast(ctx) || this.continuousSpellTimer == 0) {
                this.continuousSpellTimer = 0;
                this.cooldown = ((ISpellCaster)this.attacker).getContinuousSpell().getCooldown() + this.baseCooldown;
                this.setContinuousSpellAndNotify(Spells.NONE, new SpellModifiers());
                ((ISpellCaster)this.attacker).setSpellCounter(0);
                return;
            }
            if (currentTick == 1) {
                WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), (class_1309)this.attacker, ((ISpellCaster)this.attacker).getModifiers()));
            }
        } else if (--this.cooldown == 0) {
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible) {
                this.cooldown = 10;
                return;
            }
            double dx = this.target.method_23317() - this.attacker.method_23317();
            double dz = this.target.method_23321() - this.attacker.method_23321();
            ArrayList<Spell> spells = new ArrayList<Spell>(((ISpellCaster)this.attacker).getSpells());
            if (!spells.isEmpty() && !this.attacker.method_37908().field_9236) {
                while (!spells.isEmpty()) {
                    Spell spell = (Spell)spells.get(this.attacker.method_37908().field_9229.method_43048(spells.size()));
                    SpellModifiers modifiers = ((ISpellCaster)this.attacker).getModifiers();
                    if (spell != null && this.attemptCastSpell(spell, modifiers)) {
                        this.attacker.method_36456((float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f);
                        return;
                    }
                    spells.remove(spell);
                }
            }
            this.cooldown = this.baseCooldown;
        } else if (this.cooldown < 0) {
            this.cooldown = this.baseCooldown;
        }
    }

    private boolean attemptCastSpell(Spell spell, SpellModifiers modifiers) {
        if (WizardryEventBus.getInstance().fire(new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, spell, (class_1309)this.attacker, modifiers))) {
            return false;
        }
        EntityCastContext ctx = new EntityCastContext(this.attacker.method_37908(), (class_1309)this.attacker, class_1268.field_5808, 0, this.target, modifiers);
        if (!spell.cast(ctx)) {
            return false;
        }
        if (spell.isInstantCast()) {
            WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.NPC, spell, (class_1309)this.attacker, modifiers));
            this.cooldown = this.baseCooldown + spell.getCooldown();
            if (!this.attacker.method_37908().field_9236 && spell.requiresPacket()) {
                NPCSpellCastS2C msg = new NPCSpellCastS2C(this.attacker.method_5628(), this.target.method_5628(), class_1268.field_5808, spell, modifiers);
                Services.NETWORK_HELPER.sendToTracking((class_1297)this.attacker, msg);
            }
        } else {
            this.continuousSpellTimer = this.continuousSpellDuration - 1;
            this.setContinuousSpellAndNotify(spell, modifiers);
            this.attacker.method_5980(this.target);
            T t = this.attacker;
            if (t instanceof AbstractWizard) {
                AbstractWizard wizard = (AbstractWizard)t;
                wizard.setSpellTargetId(this.target.method_5628());
            }
        }
        return true;
    }
}

