/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.goal;

import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.mixin.accessor.BlazeAccessor;
import com.binaris.wizardry.core.networking.s2c.NPCSpellCastS2C;
import com.binaris.wizardry.core.platform.Services;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1545;
import net.minecraft.class_5134;

public class BlazeLikeSpellAttackGoal
extends class_1352 {
    private final class_1545 blaze;
    private final Spell spell;
    private int attackStep;
    private int attackTime;
    private int lastSeen;

    public BlazeLikeSpellAttackGoal(class_1545 blaze, Spell spell) {
        this.blaze = blaze;
        this.spell = spell;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.blaze.method_5968();
        return target != null && target.method_5805() && this.blaze.method_18395(target);
    }

    public void method_6269() {
        this.attackStep = 0;
    }

    public void method_6270() {
        ((BlazeAccessor)this.blaze).callSetCharged(false);
        this.lastSeen = 0;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        --this.attackTime;
        class_1309 target = this.blaze.method_5968();
        if (target == null) {
            return;
        }
        boolean hasSight = this.blaze.method_5985().method_6369((class_1297)target);
        this.lastSeen = hasSight ? 0 : this.lastSeen + 1;
        double distanceSq = this.blaze.method_5858((class_1297)target);
        double followDistSq = this.getFollowDistance() * this.getFollowDistance();
        if (distanceSq < 4.0) {
            if (!hasSight) {
                return;
            }
            if (this.attackTime <= 0) {
                this.attackTime = 20;
                this.blaze.method_6121((class_1297)target);
            }
            this.blaze.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
            super.method_6268();
            return;
        }
        if (distanceSq < followDistSq && hasSight) {
            if (this.attackTime <= 0) {
                ++this.attackStep;
                if (this.attackStep == 1) {
                    this.attackTime = 60;
                    ((BlazeAccessor)this.blaze).callSetCharged(true);
                } else if (this.attackStep <= 4) {
                    this.attackTime = 6;
                } else {
                    this.attackTime = 100;
                    this.attackStep = 0;
                    ((BlazeAccessor)this.blaze).callSetCharged(false);
                }
                if (this.attackStep > 1) {
                    this.attemptCast(target);
                }
            }
            this.blaze.method_5988().method_6226((class_1297)target, 10.0f, 10.0f);
            super.method_6268();
            return;
        }
        if (this.lastSeen < 5) {
            this.blaze.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
        }
        super.method_6268();
    }

    private void attemptCast(class_1309 target) {
        SpellModifiers modifiers = new SpellModifiers();
        EntityCastContext ctx = new EntityCastContext(this.blaze.method_37908(), (class_1309)this.blaze, class_1268.field_5808, 0, target, modifiers);
        this.spell.cast(ctx);
        WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.NPC, this.spell, (class_1309)this.blaze, modifiers));
        if (!this.blaze.method_37908().field_9236 && this.spell.requiresPacket()) {
            NPCSpellCastS2C msg = new NPCSpellCastS2C(this.blaze.method_5628(), target.method_5628(), class_1268.field_5808, this.spell, modifiers);
            Services.NETWORK_HELPER.sendToTracking((class_1297)this.blaze, msg);
        }
    }

    private double getFollowDistance() {
        return this.blaze.method_26825(class_5134.field_23717);
    }
}

