/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.goal;

import com.binaris.wizardry.api.content.data.MinionData;
import com.binaris.wizardry.core.platform.Services;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_7;

public class MinionFollowOwnerGoal
extends class_1352 {
    private final class_1308 minion;
    private final MinionData data;
    private final class_4538 level;
    private final float speedModifier = 1.0f;
    private final float stopDistance = 2.0f;
    private final float startDistance = 10.0f;
    private final boolean canFly = false;
    private final class_1408 navigation;
    private class_1309 owner;
    private float oldWaterCost;
    private int timeToRecalcPath;

    public MinionFollowOwnerGoal(class_1308 minion) {
        if (!Services.OBJECT_DATA.isMinion((class_1297)minion)) {
            throw new RuntimeException("MinionFollowOwnerGoal can only be used by minions!");
        }
        this.minion = minion;
        this.data = Services.OBJECT_DATA.getMinionData(this.minion);
        this.level = minion.method_37908();
        this.navigation = minion.method_5942();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        if (!(minion.method_5942() instanceof class_1409) && !(minion.method_5942() instanceof class_1407)) {
            throw new IllegalArgumentException("Unsupported mob type for MinionFollowOwnerGoal");
        }
    }

    public boolean method_6264() {
        class_1657 livingentity = this.data.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.method_7325()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.minion.method_5858((class_1297)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean method_6266() {
        if (this.navigation.method_6357()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.minion.method_5858((class_1297)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.minion.method_5765() || this.minion.method_5934();
    }

    public void method_6269() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.minion.method_5944(class_7.field_18);
        this.minion.method_5941(class_7.field_18, 0.0f);
    }

    public void method_6270() {
        this.owner = null;
        this.navigation.method_6340();
        this.minion.method_5941(class_7.field_18, this.oldWaterCost);
    }

    public void method_6268() {
        this.minion.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.minion.method_5978());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.method_38847(10);
            if (this.minion.method_5858((class_1297)this.owner) >= 144.0) {
                this.teleportToOwner();
            } else {
                Objects.requireNonNull(this);
                this.navigation.method_6335((class_1297)this.owner, 1.0);
            }
        }
    }

    private void teleportToOwner() {
        class_2338 blockpos = this.owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.method_10263() + j, blockpos.method_10264() + k, blockpos.method_10260() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new class_2338(x, y, z))) {
            return false;
        }
        this.minion.method_5808((double)x + 0.5, (double)y, (double)z + 0.5, this.minion.method_36454(), this.minion.method_36455());
        this.navigation.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 pos) {
        class_7 blockpathtypes = class_14.method_23476((class_1922)this.level, (class_2338.class_2339)pos.method_25503());
        if (blockpathtypes != class_7.field_12) {
            return false;
        }
        class_2680 blockstate = this.level.method_8320(pos.method_10074());
        Objects.requireNonNull(this);
        if (blockstate.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 blockpos = pos.method_10059((class_2382)this.minion.method_24515());
        return this.level.method_8587((class_1297)this.minion, this.minion.method_5829().method_996(blockpos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.minion.method_6051().method_43048(max - min + 1) + min;
    }
}

