/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.living;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.living.ISpellCaster;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.api.content.util.NBTExtras;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.entity.goal.AttackSpellBasicGoal;
import com.binaris.wizardry.content.entity.goal.HardLookAtTargetGoal;
import com.binaris.wizardry.content.entity.goal.RangedKitingGoal;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.content.item.WizardArmorType;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1370;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4255;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWizard
extends class_1314
implements ISpellCaster {
    private static final class_2940<Integer> HEAL_COOLDOWN = class_2945.method_12791(AbstractWizard.class, (class_2941)class_2943.field_13327);
    private static final class_2940<String> ELEMENT = class_2945.method_12791(AbstractWizard.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> CONTINUOUS_SPELL = class_2945.method_12791(AbstractWizard.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> SPELL_COUNTER = class_2945.method_12791(AbstractWizard.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TEXTURE_INDEX = class_2945.method_12791(AbstractWizard.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SPELL_TARGET_ID = class_2945.method_12791(AbstractWizard.class, (class_2941)class_2943.field_13327);
    protected List<Spell> spells = new ArrayList<Spell>(4);

    public AbstractWizard(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23716, 30.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new RangedKitingGoal(this, 0.6));
        this.field_6201.method_6277(3, (class_1352)new HardLookAtTargetGoal(this, 10.0f, 10.0f));
        this.field_6201.method_6277(4, new AttackSpellBasicGoal<AbstractWizard>(this, 14.0f, 30, 50));
        this.field_6201.method_6277(5, (class_1352)new class_4255((class_1308)this, true));
        this.field_6201.method_6277(6, (class_1352)new class_1370((class_1314)this, 0.6));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, AbstractWizard.class, 5.0f, 0.02f));
        this.field_6201.method_6277(7, (class_1352)new class_1379((class_1314)this, 0.6));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[]{AbstractWizard.class}));
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1308.class, 0, false, true, entity -> entity != null && !entity.method_5767() && entity instanceof class_1569));
    }

    public void method_6007() {
        super.method_6007();
        this.handleContinuousSpellOnClient();
        this.handleSelfHealing();
    }

    private void handleContinuousSpellOnClient() {
        class_1297 entity;
        if (!this.method_37908().field_9236) {
            return;
        }
        Spell continuousSpell = this.getContinuousSpell();
        int spellCounter = this.getSpellCounter();
        if (continuousSpell == Spells.NONE || spellCounter <= 0) {
            return;
        }
        int targetId = this.getSpellTargetId();
        class_1309 target = null;
        if (targetId != -1 && (entity = this.method_37908().method_8469(targetId)) instanceof class_1309) {
            class_1309 livingEntity;
            target = livingEntity = (class_1309)entity;
        }
        if (target != null) {
            EntityCastContext ctx = new EntityCastContext(this.method_37908(), (class_1309)this, class_1268.field_5808, spellCounter, target, this.getModifiers());
            continuousSpell.cast(ctx);
        }
    }

    private void handleSelfHealing() {
        int healCooldown = this.getHealCooldown();
        if (this.shouldStartHealing()) {
            this.method_6025(this.getElement() == Elements.HEALING ? 8.0f : 4.0f);
            this.setHealCooldown(-1);
            return;
        }
        if (healCooldown == -1 && !this.method_29504()) {
            if (this.method_37908().field_9236) {
                ParticleBuilder.spawnHealParticles(this.method_37908(), (class_1309)this);
                return;
            }
            if (this.method_6032() < 10.0f) {
                this.setHealCooldown(150);
            } else {
                this.setHealCooldown(400);
            }
            class_3414 sound = class_3414.method_47908((class_2960)new class_2960(Spells.HEAL.getLocation().method_12836(), "spell." + Spells.HEAL.getLocation().method_12832()));
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), sound, class_3419.field_15248, Spells.HEAL.getVolume(), Spells.HEAL.getPitch() + Spells.HEAL.getPitchVariation() * (this.method_37908().field_9229.method_43057() - 0.5f));
        }
        if (healCooldown > 0) {
            this.setHealCooldown(healCooldown - 1);
        }
    }

    private boolean shouldStartHealing() {
        return this.getHealCooldown() == 0 && this.method_6032() < this.method_6063() && this.method_6032() > 0.0f && !this.method_6059(EBMobEffects.ARCANE_JAMMER.get());
    }

    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 mobSpawnType, @Nullable class_1315 spawnData, @Nullable class_2487 tag) {
        this.setTextureIndex(this.field_5974.method_43048(6));
        if (((String)this.field_6011.method_12789(ELEMENT)).isEmpty()) {
            Element element = this.chooseElement();
            this.setElement(element);
        }
        this.equipArmorAndDisableDrops(this.getElement());
        this.spells.add(Spells.MAGIC_MISSILE);
        SpellTier maxTier = EntityUtil.populateSpells(this.spells, this.getElement(), false, 3, this.field_5974);
        this.prepareWandWithSpells(this.getElement(), maxTier);
        this.setHealCooldown(50);
        return super.method_5943(level, difficulty, mobSpawnType, spawnData, tag);
    }

    private Element chooseElement() {
        if (this.field_5974.method_43056()) {
            ArrayList<Element> elements = new ArrayList<Element>(Services.REGISTRY_UTIL.getElements());
            elements.remove(Elements.MAGIC);
            return (Element)elements.get(this.field_5974.method_43048(elements.size()));
        }
        return Elements.MAGIC;
    }

    private void equipArmorAndDisableDrops(Element element) {
        for (class_1304 slot : InventoryUtil.ARMOR_SLOTS) {
            this.method_5673(slot, new class_1799((class_1935)RegistryUtils.getArmor(WizardArmorType.WIZARD, element, slot)));
        }
        for (class_1304 slot : class_1304.values()) {
            this.method_5946(slot, 0.0f);
        }
    }

    private void prepareWandWithSpells(Element element, SpellTier maxTier) {
        ArrayList<Spell> list = new ArrayList<Spell>(this.spells);
        list.add(Spells.HEAL);
        class_1792 item = RegistryUtils.getWand(maxTier, element);
        if (item == class_1802.field_8162 || !(item instanceof WandItem)) {
            EBLogger.warn("Failed to create wand for wizard with element {} and max tier {}. Defaulting to apprentice wand.", element.getName(), maxTier);
            item = EBItems.APPRENTICE_WAND.get();
        }
        class_1799 wand = new class_1799((class_1935)item);
        Spell[] spellsArray = list.toArray(new Spell[0]);
        WandHelper.setSpells(wand, Arrays.asList(spellsArray));
        this.method_5673(class_1304.field_6173, wand);
    }

    public boolean method_5643(class_1282 source, float damage) {
        if (source.method_5529() instanceof class_1657) {
            EBAdvancementTriggers.ANGER_WIZARD.triggerFor((class_1657)source.method_5529());
        }
        return super.method_5643(source, damage);
    }

    @NotNull
    public class_2561 method_5476() {
        if (this.method_16914() || this.getElement() == null) {
            return super.method_5476();
        }
        return this.getElement().getWizardName();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HEAL_COOLDOWN, (Object)-1);
        this.field_6011.method_12784(ELEMENT, (Object)"");
        this.field_6011.method_12784(CONTINUOUS_SPELL, (Object)Spells.NONE.getLocation().toString());
        this.field_6011.method_12784(SPELL_COUNTER, (Object)0);
        this.field_6011.method_12784(TEXTURE_INDEX, (Object)0);
        this.field_6011.method_12784(SPELL_TARGET_ID, (Object)-1);
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        Element element = this.getElement();
        if (element != null) {
            nbt.method_10582("element", element.getLocation().toString());
        }
        nbt.method_10569("skin", this.getTextureIndex());
        NBTExtras.storeTagSafely(nbt, "spells", (class_2520)NBTExtras.listToTag(this.spells, spell -> class_2519.method_23256((String)spell.getLocation().toString())));
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        Element element = Services.REGISTRY_UTIL.getElement(class_2960.method_12829((String)nbt.method_10558("element")));
        if (element != null) {
            this.setElement(element);
        }
        this.setTextureIndex(nbt.method_10550("skin"));
        this.spells = (List)NBTExtras.tagToList(nbt.method_10554("spells", 8), tag -> Services.REGISTRY_UTIL.getSpell(class_2960.method_12829((String)tag.method_10714())));
    }

    private int getHealCooldown() {
        return (Integer)this.field_6011.method_12789(HEAL_COOLDOWN);
    }

    private void setHealCooldown(int cooldown) {
        this.field_6011.method_12778(HEAL_COOLDOWN, (Object)cooldown);
    }

    @Nullable
    public Element getElement() {
        return Services.REGISTRY_UTIL.getElement(class_2960.method_12829((String)((String)this.field_6011.method_12789(ELEMENT))));
    }

    public void setElement(Element element) {
        this.field_6011.method_12778(ELEMENT, (Object)element.getLocation().toString());
    }

    public int getTextureIndex() {
        return (Integer)this.field_6011.method_12789(TEXTURE_INDEX);
    }

    public void setTextureIndex(int index) {
        this.field_6011.method_12778(TEXTURE_INDEX, (Object)index);
    }

    @Override
    @NotNull
    public List<Spell> getSpells() {
        return this.spells;
    }

    public void setSpells(List<Spell> spells) {
        this.spells = spells;
    }

    @Override
    @NotNull
    public Spell getContinuousSpell() {
        Spell spell = Services.REGISTRY_UTIL.getSpell(class_2960.method_12829((String)((String)this.field_6011.method_12789(CONTINUOUS_SPELL))));
        return spell == null ? Spells.NONE : spell;
    }

    @Override
    public void setContinuousSpell(Spell spell) {
        this.field_6011.method_12778(CONTINUOUS_SPELL, (Object)spell.getLocation().toString());
    }

    @Override
    public int getSpellCounter() {
        return (Integer)this.field_6011.method_12789(SPELL_COUNTER);
    }

    @Override
    public void setSpellCounter(int count) {
        this.field_6011.method_12778(SPELL_COUNTER, (Object)count);
    }

    public int getSpellTargetId() {
        return (Integer)this.field_6011.method_12789(SPELL_TARGET_ID);
    }

    public void setSpellTargetId(int targetId) {
        this.field_6011.method_12778(SPELL_TARGET_ID, (Object)targetId);
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }
}

